/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.procedure.ListenerBase;

final public class SuperRelations extends UnaryQuery<InternalProcedure<IntSet>> {
	
//	public ArrayList<InternalProcedure<IntSet>> procs = null;
    
    private SuperRelations(final int resource) {
        super(resource);
    }
    
    final static SuperRelations entry(final QueryProcessor provider, final int r) {
        
        return (SuperRelations)provider.superRelationsMap.get(r);

    }

    final static IntSet runner(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final InternalProcedure<IntSet> procedure) {

        SuperRelations entry = (SuperRelations)provider.superRelationsMap.get(r);
        if(entry == null) {

        	entry = new SuperRelations(r);
        	entry.setPending();
        	entry.clearResult(provider.querySupport);
        	entry.putEntry(provider);
        	
        	return (IntSet)provider.performForEach(graph, entry, parent, listener, procedure);
            
        } else {
        	
            if(!entry.isReady()) {
                throw new IllegalStateException();
            }
            return (IntSet)provider.performForEach(graph, entry, parent, listener, procedure);
            
        }

    }
    
    final static IntSet runner2(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final InternalProcedure<IntSet> procedure) throws Throwable {

        SuperRelations entry = (SuperRelations)provider.superRelationsMap.get(r);
        if(entry == null) {

            entry = new SuperRelations(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            
            return (IntSet)provider.performForEach2(graph, entry, parent, listener, procedure);
            
        } else {
            
            if(!entry.isReady()) {
                throw new IllegalStateException();
            }
            return (IntSet)provider.performForEach2(graph, entry, parent, listener, procedure);
            
        }

    }    
    
    final public static void queryEach(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final InternalProcedure<IntSet> procedure) {

        if(parent == null && listener == null) {
        	SuperRelations entry = (SuperRelations)provider.superRelationsMap.get(r);
        	if(entry != null && entry.isReady()) {
        	    entry.performFromCache(graph, provider, procedure);
        	    return;
        	}
        }
        
        runner(graph, r, provider, parent, listener, procedure);
         
    }

    final public static IntSet queryEach2(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final InternalProcedure<IntSet> procedure) throws Throwable {

        if(parent == null && listener == null) {
            SuperRelations entry = (SuperRelations)provider.superRelationsMap.get(r);
            if(entry != null && entry.isReady()) {
                return (IntSet)entry.get(graph, provider, procedure);
            }
        }
        
        return runner2(graph, r, provider, parent, listener, procedure);
         
    }
    
 	@Override
 	public UnaryQuery<InternalProcedure<IntSet>> getEntry(QueryProcessor provider) {
        return provider.superRelationsMap.get(id);
 	}
 	
 	@Override
 	public void putEntry(QueryProcessor provider) {
        provider.superRelationsMap.put(id, this);
 	}

 	@Override
 	final public void removeEntry(QueryProcessor provider) {
 		provider.superRelationsMap.remove(id);
 	}
 	
 	static int histoCounter = 0;
 	static IntSet EMPTY_SET = new IntSet();
    static int counter = 0;
    
    class Koss {
        
        private TIntHashSet set = null;
        public int single = 0;
        
        public boolean add(int val) {
            if(single == val) return false;
            if(single == 0) {
                single = val;
                return true;
            }
            if(set == null) set = new TIntHashSet(4);
            return set.add(val);
        }
        
        public int size() {
            
            if(single == 0) return 0;
            if(set == null) return 1;
            return set.size() + 1;
            
        }

        public void forEach(TIntProcedure proc) {
            if(single > 0) proc.execute(single);
            if(set != null) set.forEach(proc);
        }
        
    }

 	@Override
 	public Object computeForEach(final ReadGraphImpl graph, final QueryProcessor provider, final InternalProcedure<IntSet> procedure, final boolean store) {

 		provider.querySupport.ensureLoaded(graph, id);
 		
 	    final InternalProcedure<IntSet> proc = (InternalProcedure<IntSet>)procedure;

 	    final int subrelationOf = provider.getSubrelationOf();

 	    final IntSet result = new IntSet(provider.querySupport);

 	    final class DirectProcedure extends Koss implements IntProcedure, TIntProcedure, InternalProcedure<IntSet> {
 	    	@Override
 	    	final public boolean execute(int r) {
 	    		result.add(r);
 	    		return true;
 	    	}
 	    	@Override
 	    	final public void execute(ReadGraphImpl graph, int r) {
 	    		if(single == 0) {
 	    			single = r;
 	    			return;
 	    		}
 	    		add(r);
 	    	}
 	    	@Override
 	    	final public void execute(ReadGraphImpl graph, IntSet set) {
 	    		set.forEach(this);
 	    		addOrSet(graph, result, provider);
 	    		proc.execute(graph, result);
 	    	}
 	    	@Override
 	    	public void finished(ReadGraphImpl graph) {
 	    	}
 	    	@Override
 	    	public void exception(ReadGraphImpl graph, Throwable t) {
 	    		throw new Error("Errors are not supported.", t);
 	    	}

 	    }

 	    final DirectProcedure directProc = new DirectProcedure();

 	    provider.querySupport.getObjects(graph, id, subrelationOf, directProc);

 	    int size = directProc.size();

 	    if(size == 0) {

 	    	addOrSet(graph, EMPTY_SET, provider);
 	    	proc.execute(graph, EMPTY_SET);

 	    } else if (size == 1) {

 	    	result.add(directProc.single);
 	    	SuperRelations.queryEach(graph, directProc.single, provider, SuperRelations.this, null, directProc);

 	    } else {

 	    	//	            if((counter++ % 500) == 0) System.out.println("SR " + counter);

 	    	final TIntProcedure addToResult = new TIntProcedure() {
 	    		@Override
 	    		public boolean execute(int r) {
 	    			synchronized(result) {
 	    				result.add(r);
 	    			}
 	    			return true;
 	    		}
 	    	};

 	    	final AtomicInteger finishes = new AtomicInteger(0);

 	    	directProc.forEach(new TIntProcedure() {

 	    		@Override
 	    		public boolean execute(int arg0) {

 	    			synchronized(result) {
 	    				result.add(arg0);
 	    			}

 	    			SuperRelations.queryEach(graph, arg0, provider, SuperRelations.this, null, new InternalProcedure<IntSet>() {

 	    				@Override
 	    				public void execute(ReadGraphImpl graph, IntSet set) {
 	    					set.forEach(addToResult);
 	    					int current = finishes.addAndGet(1);
 	    					if(current == directProc.size()) {
 	    						addOrSet(graph, result, provider);
 	    						proc.execute(graph, result);
 	    						return; 
 	    					}
 	    				}

 	    				@Override
 	    				public void exception(ReadGraphImpl graph, Throwable t) {
 	    					proc.exception(graph, t);
 	    				}

 	    			});

 	    			return true;

 	    		}

 	    	});

 	    }
 	    
 	    return result;
        
    }
    
    @Override
    public String toString() {
    	return "SuperRelations[" + id + "]";
    }

    private void addOrSet(ReadGraphImpl graph, final IntSet value, QueryProcessor provider) {

        assert(!isReady());

//        ArrayList<InternalProcedure<IntSet>> p = null;

        synchronized(this) {
        
            value.trim();
            setResult(value);
            setReady();
//            p = procs;
//            procs = null; 
        
        }

//        if(p != null) {
//	        IntSet v = (IntSet)getResult();
//	        if(v != null) {
//	            for(InternalProcedure<IntSet> proc : p) proc.execute(graph, v);
//	        }
//        }
        
    }
    
    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<IntSet> procedure) {
              
        assert(isReady());

    	if(handleException(graph, procedure)) return null;
        
    	IntSet result = getResult();
    	
        procedure.execute(graph, result);
        
        return result;
        
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        
        final Semaphore s = new Semaphore(0);

        computeForEach(graph, provider, new InternalProcedure<IntSet>() {

        	@Override
        	public void execute(ReadGraphImpl graph, IntSet result) {
                s.release();
        	}

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
            	s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }

        }, true);

        while(!s.tryAcquire()) {
        	provider.resume(graph);
        }
        
    }
    

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
    	return graph.processor.isImmutable(id);
    }
    
}
