/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import java.util.ArrayList;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.RequestFlags;

final public class AsyncMultiReadEntry<T> extends CacheEntryBase {

//    public ArrayList<AsyncMultiProcedure<T>> procs = null;

    protected AsyncMultiRead<T> request;
    
    public AsyncMultiReadEntry(AsyncMultiRead<T> request) {
    	this.request = request;
    }
    
    @Override
    int makeHash() {
    	return request.hashCode();
    }
    
    @Override
    public Object getOriginalRequest() {
        return request;
    }
    
    @Override
    public void discard() {
    	super.discard();
    	request = null;
    	setResult(null);
    }
    
    final synchronized public void finish(AsyncReadGraph graph) {
    	
//    	new Exception("finish " + this).printStackTrace();
    	
    	if(!isPending()) {
    		System.err.println("aff");
    	}
    	
    	assert(isPending());

//        ArrayList<AsyncMultiProcedure<T>> p = null;

        synchronized(this) {

        	setReady();
//            p = procs;
//            procs = null; 
        
        }
        
//        if(p != null) {
//	        ArrayList<T> v = (ArrayList<T>)getResult();
//	        if(v != null) {
//	            for(AsyncMultiProcedure<T> proc : p) {
//	                for(T t : v) proc.execute(graph, t);
//	            }
//	        }
//	        
//	        for(AsyncMultiProcedure<T>  proc : p) proc.finished(graph);
//        }
        
    }

    final synchronized public void except(AsyncReadGraph graph, Throwable t) {

    	assert(isPending());

//        ArrayList<AsyncMultiProcedure<T>> p = null;

        synchronized(this) {

        	except(t);
//            p = procs;
//            procs = null; 
        
        }
        
//        if(p != null) {
//	        for(AsyncMultiProcedure<T>  proc : p) proc.exception(graph, t);
//        }
        
    }

    final synchronized public void addOrSet(Object item) {

    	assert(isPending());
    	
        ArrayList<T> value = (ArrayList<T>)getResult(); 
        value.add((T)item);
        
    }
    
    @Override
    public void clearResult(QuerySupport support) {
    	setResult(new ArrayList<T>());
    }
    
    @Override
    final public Query getQuery() {
    	
        return new Query() {

			@Override
			public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
				
				QueryProcessor qp = (QueryProcessor)provider;

				final ReadGraphImpl parentGraph = ReadGraphImpl.forRecompute(entry, qp); 

				try {

				    request.perform(parentGraph , new AsyncMultiProcedure<T>() {

                        @Override
                        public void execute(AsyncReadGraph graph, T result) {
                            addOrSet(result);
                        }
                        
                        public void finished(AsyncReadGraph graph) {
                        	finish(graph);
                        };
        				
        				@Override
        				public void exception(AsyncReadGraph graph, Throwable t) {
                            except(t);
        	            }

                    });

				} catch (Throwable t) {
                    except(t);
                    if(DebugException.DEBUG) new DebugException(t).printStackTrace();
                }
				
			}

			@Override
			public void removeEntry(QueryProcessor processor) {
		    	processor.asyncMultiReadMap.remove(request);
			}

			@Override
			public int type() {
				return RequestFlags.INVALIDATE;
			}
			
			@Override
			public String toString() {
				if(request == null) return "DISCARDED";
				else return request.toString() + statusOrException;
			}
        	
        };
        
    }

	@Override
	public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
		
		final AsyncMultiProcedure<T> proc = (AsyncMultiProcedure<T>)procedure;

        if(isExcepted()) {

            try {
                proc.exception(graph, (Throwable)getResult());
            } catch (Throwable t) {
                t.printStackTrace();
            }
            
            
        } else {
            
            final ArrayList<T> values = (ArrayList<T>)getResult();
            for(T value : values) {
                try {
                    proc.execute(graph, value);
                } catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            try {
                proc.finished(graph);
            } catch (Throwable t) {
                t.printStackTrace();
            }

        }
		
		
		
	}

//	@Override
//	public void performFromCache(int callerThread, Object provider,
//			Object procedure) {
//
//	    QueryProvider2 queryProvider = (QueryProvider2)provider;
//	    ReadGraphImpl graph = ReadGraphImpl.forFromCache(callerThread, null, new ReadGraphSupportImpl(null, queryProvider, null));
//		performFromCache(graph, provider, procedure);
//		
//	}
	
	@Override
	public String toString() {
		if(request == null) return "DISCARDED";
		else return request.toString() + statusOrException;
	}

}
