/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

import org.simantics.db.RelationInfo;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.procedure.TripleIntProcedureAdapter;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.request.RequestFlags;


final public class AssertedStatements extends CollectionBinaryQuery<TripleIntProcedure> {
    
//    public ArrayList<TripleIntProcedure> procs;
    
    public AssertedStatements(final int r1, final int r2) {
        super(r1, r2);
    }

    public static AssertedStatements newInstance(final int r1, final int r2) {
        return new AssertedStatements(r1, r2);
    }
    
    final static AssertedStatements runner(ReadGraphImpl graph, final int r1, final int r2, final QueryProcessor provider, final AssertedStatements cached, final CacheEntry parent, final ListenerBase listener, final TripleIntProcedure procedure) {
        
        AssertedStatements entry = cached != null ? cached : (AssertedStatements)provider.assertedStatementsMap.get(id(r1,r2)); 
        if(entry == null) {
        	
        	entry = new AssertedStatements(r1, r2);
        	entry.setPending();
        	entry.clearResult(provider.querySupport);
        	entry.putEntry(provider);
        	
            provider.performForEach(graph, entry, parent, listener, procedure);
            
            return entry;
            
        } else {
        	
            if(entry.isPending()) {
                synchronized(entry) {
                    if(entry.isPending()) {
                        throw new IllegalStateException();
//                    	if(entry.procs == null) entry.procs = new ArrayList<TripleIntProcedure>();
//                        entry.procs.add(procedure);
//                        provider.registerDependencies(graph, entry, parent, listener, procedure, false);
//                        return entry;
                    }
                }
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
        
        return entry;
        
    }
    
    final public static AssertedStatements queryEach(ReadGraphImpl graph, final int r1, final int r2, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final TripleIntProcedure procedure) {
        
        assert(r1 != 0);
        assert(r2 != 0);
        
        final AssertedStatements entry = (AssertedStatements)provider.assertedStatementsMap.get(id(r1,r2));
        
        if(parent == null && !(listener != null)) {
            if(entry != null && entry.isReady()) { 
                entry.performFromCache(graph, provider, procedure);
                return entry;
            }
        }

        return runner(graph, r1, r2, provider, entry, parent, listener, procedure);
         
    }

    @Override
    public BinaryQuery<TripleIntProcedure> getEntry(QueryProcessor provider) {
        return provider.assertedStatementsMap.get(id);
    }
 	
 	@Override
 	public void putEntry(QueryProcessor provider) {
        provider.assertedStatementsMap.put(id, this);
 	}

 	@Override
 	final public void removeEntry(QueryProcessor provider) {
 	    provider.assertedStatementsMap.remove(id);
 	}
 	
 	void computeInheritedAssertions(ReadGraphImpl graph, int type, final int predicate, final RelationInfo ri, final QueryProcessor queryProvider, final TripleIntProcedure proc) {
 	    
//        final AtomicBoolean found = new AtomicBoolean(0);

 	    DirectObjects.queryEach(graph, type, queryProvider.getInherits(), queryProvider, this, null, new SyncIntProcedure() {

            @Override
            public void run(ReadGraphImpl graph) {

//                if(ri.isFunctional && found.get() == 1) {
//
//                    ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has assertions from multiple inherited types.");
//                    except(exception);
//                    proc.exception(graph, exception);
//                    return;
//                    
//                }

                finish(graph, queryProvider);
                proc.finished(graph);
                
            }

            @Override
            public void execute(ReadGraphImpl graph, int inh) {
                
//                if(ri.isFunctional && found.get() == 1) return;

                inc();
                
                AssertedStatements.queryEach(graph, inh, predicate, queryProvider, AssertedStatements.this, null, new TripleIntProcedureAdapter() {

                    @Override
                    public void execute(ReadGraphImpl graph, int s, int p, int o) {

//                        if(ri.isFunctional) {
//                            
////                            if(found.get() == 1) return;
//
//                            if(found.compareAndSet(0, o)) {
                                if(addOrSet(s,p,o))
                                	proc.execute(graph, s, p, o);
//                            }
//                            // If this was a duplicate, we can ignore this
//                            else if (found.compareAndSet(o, o)) {
//                                //System.err.println("duplicates!");
//                            }
//                            // Otherwise we have error
//                            else {
//                                found.set(1);
//                            }
//                            
//                        } else {
//                            
//                            addOrSet(s, p, o);
//                            proc.execute(graph, s, p, o);
//                            
//                        }
                        
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        dec(graph);
                    }
        			
        			@Override
        			public void exception(ReadGraphImpl graph, Throwable t) {
        				proc.exception(graph, t);
        				dec(graph);
                    }
                    
                });
                
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                dec(graph);
            }
            
        });

 	}

    void computeLocalAssertions(ReadGraphImpl graph, final int type, final int predicate, final RelationInfo ri, final QueryProcessor queryProvider, final TripleIntProcedure proc) {
        
        final AtomicInteger found = new AtomicInteger(0);

        DirectObjects.queryEach(graph, type, queryProvider.getAsserts(), queryProvider, this, null, new SyncIntProcedure() {

            @Override
            public void run(ReadGraphImpl graph) {
                
                if(ri.isFunctional && found.get() > 1) {

                    ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one asserted statement.");
                    except(exception);
                    proc.exception(graph, exception);
                    return;
                    
                }

                if(ri.isFunctional && found.get() == 1) {
                                        
                    finish(graph, queryProvider);
                    proc.finished(graph);
                    return;
                    
                }

                computeInheritedAssertions(graph, type, predicate, ri, queryProvider, proc);
                
            }

            @Override
            public void execute(ReadGraphImpl graph, final int ass) {
                
                if(ri.isFunctional && found.get() > 1) return;
                
                inc();
                
                DirectObjects.queryEach(graph, ass, queryProvider.getHasPredicate(), queryProvider, AssertedStatements.this, null, new IntProcedure() {

                    @Override
                    public void execute(ReadGraphImpl graph, final int pred) {
                        
                        if(ri.isFunctional) {
                            
                            if(found.get() > 1) return;

                            inc();

                            DirectObjects.queryEach(graph, ass, queryProvider.getHasObject(), queryProvider, AssertedStatements.this, null, new IntProcedure() {

                                @Override
                                public void execute(ReadGraphImpl graph, final int object) {
                                    
                                    if(found.get() > 1) return;

                                    if(pred == predicate) {

                                    	if(found.getAndIncrement() == 0) {
                                    		if(addOrSet(type, pred, object))
                                    			proc.execute(graph, type, pred, object);
                                    	}
                                    	
                                        return;
                                        
                                    }
                                    
                                    if ( !ri.isFinal ) {

                                        inc();

                                        SuperRelations.queryEach(graph, pred, queryProvider, AssertedStatements.this, null, new InternalProcedure<IntSet>() {
                                            
                                            @Override
                                            public void execute(ReadGraphImpl graph, IntSet result) {
                                                
                                                if(found.get() > 1) {
                                                    dec(graph);
                                                    return;
                                                }

                                                if(result.contains(predicate)) {
                    
                                                    if(found.getAndIncrement() == 0) {
	                                                	if(addOrSet(type, pred, object))
	                                                		proc.execute(graph, type, pred, object);
                                                	}
                                                    
                                                }
                                                
                                                dec(graph);
                                                
                                            }
                                			
                                			@Override
                                			public void exception(ReadGraphImpl graph, Throwable t) {
                                			    
                                				proc.exception(graph, t);
                                                dec(graph);
                                				
                                            }

                                        });

                                    }

                                }
                                
                                @Override
                                public void finished(ReadGraphImpl graph) {
                                    dec(graph);
                                }
                    			
                    			@Override
                    			public void exception(ReadGraphImpl graph, Throwable t) {
                    				proc.exception(graph, t);
                                    dec(graph);
                                }

                            });
                            
                        } else {

                            inc();

                            DirectObjects.queryEach(graph, ass, queryProvider.getHasObject(), queryProvider, AssertedStatements.this, null, new IntProcedure() {

                                @Override
                                public void execute(ReadGraphImpl graph, final int object) {
                                    
                                    if(pred == predicate) {

                                        addOrSet(type, pred, object);
                                        proc.execute(graph, type, pred, object);
                                        return;
                                        
                                    }
                                    
                                    if ( !ri.isFinal ) {

                                        inc();

                                        SuperRelations.queryEach(graph, pred, queryProvider, AssertedStatements.this, null, new InternalProcedure<IntSet>() {
                                            
                                            @Override
                                            public void execute(ReadGraphImpl graph, IntSet result) {
                                                
                                                if(result.contains(predicate)) {
                    
                                                    addOrSet(type, pred, object);
                                                    proc.execute(graph, type, pred, object);

                                                }
                                                
                                                dec(graph);
                                                
                                            }
                                			
                                			@Override
                                			public void exception(ReadGraphImpl graph, Throwable t) {
                                				proc.exception(graph, t);
                                                dec(graph);
                                            }
 
                                        });

                                    }

                                }
                                
                                @Override
                                public void finished(ReadGraphImpl graph) {
                                    dec(graph);
                                }
                    			
                    			@Override
                    			public void exception(ReadGraphImpl graph, Throwable t) {
                    				proc.exception(graph, t);
                                    dec(graph);
                                }

                            });

                        }

                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        dec(graph);
                    }
        			
        			@Override
        			public void exception(ReadGraphImpl graph, Throwable t) {
        				proc.exception(graph, t);
                        dec(graph);
                    }

                });
                
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                dec(graph);
            }
            
        });
        
    }

 	@Override
    public void computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final TripleIntProcedure procedure, boolean store) {
        
        RelationInfoQuery.queryEach(graph, r2(), provider, this, null, new InternalProcedure<RelationInfo>() {

            @Override
            public void execute(ReadGraphImpl graph, RelationInfo ri) {
                
                computeLocalAssertions(graph, r1(), r2(), ri, provider, procedure);
                
            }
			
			@Override
			public void exception(ReadGraphImpl graph, Throwable t) {
				procedure.exception(graph, t);
            }
 
        });
        
    }
    
    @Override
    public String toString() {
    	return "AssertedStatements2[" + r1() + " - " + r2() + "]";
    }

    private boolean addOrSet(int s, int p, int o) {
        
    	assert(isPending());
        
        IntArray value = (IntArray)getResult();
        if(value.data != null) {
			for(int i = 0;i < value.sizeOrData ; i+=3) {
				int existingP = value.data[i+1];
				if(p == existingP) {
					int existingO = value.data[i+2];
					if(existingO == o) return false;
				}
			}
        	value.add(s);
        	value.add(p);
        	value.add(o);
        } else {
        	value.add(s);
        	value.add(p);
        	value.add(o);
        }
        
        return true;
        
    }
    
    final private void finish(ReadGraphImpl graph, QueryProcessor provider) {
        
    	assert(isPending());

//        ArrayList<TripleIntProcedure> p = null;

        synchronized(this) {
        	
        	setReady();
//            p = procs;
//            procs = null; 
        
        }
        
//        if(p != null) {
//        	final IntArray value = (IntArray)getResult();
//        	for(TripleIntProcedure proc : p) {
//        		for(int i=0;i<value.size();i+=3) {
//        			proc.execute(graph, value.data[i], value.data[i+1], value.data[i+2]);
//        		}
//        	}
//
//        	for(TripleIntProcedure proc : p) proc.finished(graph);
//        }

    }

    @Override
    public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, final TripleIntProcedure procedure) {
        
    	assert(isReady());
        
    	if(handleException(graph, procedure)) return;
    	
        final IntArray value = (IntArray)getResult();
        for(int i=0;i<value.size();i+=3) {
        	procedure.execute(graph, value.data[i], value.data[i+1], value.data[i+2]);
        }

        procedure.finished(graph);
        
    }
    
    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        
        final Semaphore s = new Semaphore(0);

        computeForEach(graph, provider, new TripleIntProcedureAdapter() {

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }
			
			@Override
			public void exception(ReadGraphImpl graph, Throwable t) {
				throw new Error("Error in recompute", t);
            }
    
        }, true);
        
        try {
            s.acquire();
        } catch (InterruptedException e) {
            throw new Error(e);
        }
        
    }
    
    @Override
    public int type() {
        return RequestFlags.IMMEDIATE_UPDATE;
    }
    

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
    	return graph.processor.isImmutable(r1());
    }
    
}
