/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;

import org.simantics.db.RelationInfo;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.procedure.ListenerBase;


final public class AssertedPredicates extends CollectionUnaryQuery<IntProcedure> {
	
//	public ArrayList<IntProcedure> procs = null;
	
    public AssertedPredicates(final int r) {
        super(r);
    }

    public static AssertedPredicates newInstance(final int r) {
        return new AssertedPredicates(r);
    }
    
    final static void runner(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final IntProcedure procedure) {

        AssertedPredicates entry = (AssertedPredicates)provider.assertedPredicatesMap.get(r);
        if(entry == null) {
        	
        	entry = new AssertedPredicates(r);
        	entry.setPending();
        	entry.clearResult(provider.querySupport);
        	entry.putEntry(provider);
        	
            provider.performForEach(graph, entry, parent, listener, procedure);
            
        } else {
        	
            if(!entry.isReady()) {
            	synchronized(entry) {
                    if(!entry.isReady()) {
                        throw new IllegalStateException();
//                    	if(entry.procs == null) entry.procs = new ArrayList<IntProcedure>();
//                    	entry.procs.add(procedure);
//                    	return;
                    }
            	}
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }

    }
    
    final public static void queryEach(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final IntProcedure procedure) {
        
    	if(parent == null && listener == null) {
        	AssertedPredicates entry = (AssertedPredicates)provider.assertedPredicatesMap.get(r);
        	if(entry != null && entry.isReady()) { 
        		entry.performFromCache(graph, provider, procedure);
        		return;
        	}
        }
        
        runner(graph, r, provider, parent, listener, procedure);
         
    }

    @Override
    public UnaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.assertedPredicatesMap.get(id);
    }
 	
 	@Override
 	public void putEntry(QueryProcessor provider) {
        provider.assertedPredicatesMap.put(id, this);
 	}

 	@Override
 	final public void removeEntry(QueryProcessor provider) {
 	    provider.assertedPredicatesMap.remove(id);
 	}
 	
 	void computeInheritedAssertions(ReadGraphImpl graph, int type, final QueryProcessor queryProvider, final IntProcedure proc, final boolean store) {

 	    DirectObjects.queryEach(graph, type, queryProvider.getInherits(), queryProvider, this, null, new SyncIntProcedure() {

            @Override
            public void run(ReadGraphImpl graph) {
                
//                finish(graph, queryProvider);
//        		proc.finished(graph);
                
            }

            @Override
            public void execute(ReadGraphImpl graph,int inh) {

            	inc();
                
                AssertedPredicates.queryEach(graph, inh, queryProvider, AssertedPredicates.this, null, new IntProcedure() {

                    @Override
                    public void execute(ReadGraphImpl graph, int ass) {
                            
                    	addOrSet(ass);
//                    	proc.execute(graph, ass);
                        
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        dec(graph);
                    }
        			
        			@Override
        			public void exception(ReadGraphImpl graph, Throwable t) {
//        				proc.exception(graph, t);
                    }
                    
                });
                
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            	
                dec(graph);
                
            }
            
        });

 	}

    @Override
    public Object computeForEach(ReadGraphImpl graph, final QueryProcessor queryProvider, final IntProcedure proc, final boolean store) {

        computeInheritedAssertions(graph, id, queryProvider, proc, store);

    	DirectObjects.queryEach(graph, id, queryProvider.getAsserts(), queryProvider, this, null, new IntProcedure() {

            @Override
            public void execute(ReadGraphImpl graph, final int ass) {
                
                DirectObjects.queryEach(graph, ass, queryProvider.getHasPredicate(), queryProvider, AssertedPredicates.this, null, new IntProcedure() {

                    @Override
                    public void execute(ReadGraphImpl graph, final int pred) {

                    	addOrSetHiding(graph, pred, AssertedPredicates.this);
//                    	proc.execute(graph, pred);
                        return;
                        
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                    }
        			
        			@Override
        			public void exception(ReadGraphImpl graph, Throwable t) {
//        				proc.exception(graph, t);
                    }

                });
                
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

			@Override
			public void exception(ReadGraphImpl graph, Throwable t) {
//				proc.exception(graph, t);
			}
            
        });
    	
        finish(graph, queryProvider);

    	performFromCache(graph, queryProvider, proc);
        
        return getResult();
        
    }
    
    @Override
    public String toString() {
    	return "AssertedPredicates[" + id + "]";
    }
    
    final public void finish(ReadGraphImpl graph, QueryProcessor provider) {
        
    	assert(!isReady());

//        ArrayList<IntProcedure> p = null;

        synchronized(this) {

        	setReady();
//            p = procs;
//            procs = null; 
        
        }

//        if(p != null) {
//	        IntArray v = (IntArray)getResult();
//	        if(v.data == null) {
//	            if(v.sizeOrData != IntArray.NO_DATA) {
//	                for(IntProcedure proc : p) proc.execute(graph, v.sizeOrData);
//	            }
//	        } else {
//	            for(IntProcedure proc : p) {
//	                for(int i = 0;i < v.sizeOrData ; i++) proc.execute(graph, v.data[i]);
//	            }
//	        }
//	        
//	        for(IntProcedure proc : p) proc.finished(graph);
//        }

    }

    synchronized private void addOrSet(int add) {

    	assert(isPending());
    	
        IntArray value = (IntArray)getResult(); 
        value.add(add);
        
    }

	final static InternalProcedure<RelationInfo> ip = new InternalProcedure<RelationInfo>() {

		@Override
		public void execute(ReadGraphImpl graph, RelationInfo result) {
		}

		@Override
		public void exception(ReadGraphImpl graph, Throwable throwable) {
		}

	};

	final static InternalProcedure<IntSet> ip2 = new InternalProcedure<IntSet>() {

		@Override
		public void execute(ReadGraphImpl graph, IntSet result) {
		}

		@Override
		public void exception(ReadGraphImpl graph, Throwable throwable) {
		}

	};

	synchronized private void addOrSetHiding(ReadGraphImpl graph, int add, CacheEntry parent) {

    	assert(isPending());
    	
        IntArray value = (IntArray)getResult(); 
		RelationInfo ri = RelationInfoQuery.queryEach(graph, add, graph.processor, parent, null, ip);
		if(ri.isFunctional) {
			// Replace existing functional predicate if found
			try {
				IntSet supers = SuperRelations.queryEach2(graph, add, graph.processor, parent, null, ip2);
		        if(value.data == null) {
		            if(value.sizeOrData != IntArray.NO_DATA) {
		            	if(supers.contains(value.sizeOrData)) {
		            		value.sizeOrData = add;
		            		return;
		            	}
		            }
		        } else {
		            for(int i = 0;i < value.sizeOrData ; i++) {
		            	if(supers.contains(value.data[i])) {
		            		value.data[i] = add;
		            		return;
		            	}
		            }
		        }
			} catch (Throwable e) {
				except(e);
				return;
			}
		}
	        
	    // No replacement - append
        value.add(add);

    }
    
    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, final IntProcedure procedure) {

    	assert(isReady());
    	
    	if(handleException(graph, procedure)) return EXCEPTED;
    	
        final IntArray value = (IntArray)getResult();
        if(value.data == null) {
            if(value.sizeOrData != IntArray.NO_DATA) procedure.execute(graph, value.sizeOrData);
        } else {
            for(int i = 0;i < value.sizeOrData ; i++) procedure.execute(graph, value.data[i]);
        }

        procedure.finished(graph);
        
        return value;
        
    }
    
    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        
        final Semaphore s = new Semaphore(0);

        computeForEach(graph, provider, new IntProcedureAdapter() {

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
            	s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }

        }, true);

        while(!s.tryAcquire()) {
        	provider.resume(graph);
        }
        
    }
    
    
}
