/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;

public final class RequestUtil {
    private static final boolean TRACE_SCHEDULE = false;
    private static final boolean TRACE_WAITED_TIME = false;
    private static final boolean TRACE_TIMEOUT = false;
    private static final boolean TRACE_RESULT_TIME = false;

    public static final <R> R trySyncRequest(Session session, long requestStartTimeout, long requestExecutionTimeout, R timeoutResult, Read<R> read, Procedure<R> procedure) throws DatabaseException, InterruptedException {
        if (requestStartTimeout < 0L) {
            throw new IllegalArgumentException("request start timeout must be >= 0, got " + requestStartTimeout);
        }
        ResultProcedure<R> proc = new ResultProcedure<R>();
        TimeoutingRequest<R> req = new TimeoutingRequest<R>(read, procedure);
        session.asyncRequest(req, proc);
        if (!req.waitForRequestStart(requestStartTimeout)) {
            return timeoutResult;
        }
        return proc.waitForResultOrException(requestExecutionTimeout, timeoutResult);
    }

    public static final <R> R trySyncRequest(Session session, long requestStartTimeout, long requestExecutionTimeout, Read<R> read, Procedure<R> procedure) throws DatabaseException, InterruptedException {
        return RequestUtil.trySyncRequest(session, requestStartTimeout, requestExecutionTimeout, null, read, procedure);
    }

    public static final <R> R trySyncRequest(Session session, long requestStartTimeout, long requestExecutionTimeout, R timeoutResult, Read<R> read) throws DatabaseException, InterruptedException {
        return RequestUtil.trySyncRequest(session, requestStartTimeout, requestExecutionTimeout, timeoutResult, read, null);
    }

    public static final <R> R trySyncRequest(Session session, long requestStartTimeout, long requestExecutionTimeout, Read<R> read) throws DatabaseException, InterruptedException {
        return RequestUtil.trySyncRequest(session, requestStartTimeout, requestExecutionTimeout, null, read, null);
    }

    static class ResultProcedure<R>
    extends Semaphore
    implements Procedure<R> {
        private static final long serialVersionUID = 8645926264625496924L;
        private static final Object NO_RESULT = new Object();
        private Object resultOrException = NO_RESULT;

        public ResultProcedure() {
            super(0);
        }

        public void execute(R result) {
            this.resultOrException = result;
            this.release();
        }

        public void exception(Throwable t) {
            this.resultOrException = t;
            this.release();
        }

        public R waitForResultOrException(long timeout, R timeoutResult) throws DatabaseException, InterruptedException {
            long nt0 = System.nanoTime();
            if (timeout < 0L) {
                this.acquire();
            } else {
                this.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            Object r = this.resultOrException;
            if (r == NO_RESULT) {
                return timeoutResult;
            }
            if (r instanceof Throwable) {
                if (r instanceof DatabaseException) {
                    throw (DatabaseException)((Object)r);
                }
                throw new DatabaseException((Throwable)r);
            }
            return (R)r;
        }
    }

    static class TimeoutingRequest<R>
    extends Semaphore
    implements Read<R> {
        private static final long serialVersionUID = -5216095211800988013L;
        Read<R> wrappedRequest;
        Procedure<R> wrappedProcedure;
        AtomicInteger state = new AtomicInteger();

        public TimeoutingRequest(Read<R> request, Procedure<R> procedure) {
            super(0);
            this.wrappedRequest = request;
            this.wrappedProcedure = procedure;
        }

        public R perform(ReadGraph graph) throws DatabaseException {
            if (this.state.compareAndSet(0, 1)) {
                this.release();
                return (R)(this.wrappedProcedure != null ? graph.syncRequest(this.wrappedRequest, this.wrappedProcedure) : graph.syncRequest(this.wrappedRequest));
            }
            this.release();
            return null;
        }

        public boolean waitForRequestStart(long timeout) throws InterruptedException {
            long nt0 = System.nanoTime();
            this.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            return !this.state.compareAndSet(0, 2);
        }
    }
}

