/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;

/**
 * This interface is not intended to be implemented directly. Extend
 * {@link StyleBase} instead.
 * 
 * @see StyleBase
 * @author Antti Villberg
 */
public interface Style {

    /**
     * Activates this style. Intended to start tracking the diagram items
     * contained by the specified group and to request style applications
     * whenever necessary through the specified profile observer. If a style
     * instance is already active, re-activation should not do anything. A style
     * can be re-activated after being deactivated.
     * 
     * @param backend
     * @param runtimeDiagram
     * @param configuration
     * @param group
     * @param observer
     */
    void activate(RequestProcessor backend, Resource runtimeDiagram, Resource entry, Group group, EvaluationContext observer);

    /**
     * Deactivates this style. Intended to stop tracking the currently tracked
     * group of diagram items and clean the diagram scene graph up by
     * removing/disabling all scene graph contributions produced by this style.
     * Deactivating an inactive style does nothing.
     * 
     * @param backend
     * @param runtimeDiagram
     * @param configuration
     * @param group
     * @param observer
     */
    void deactivate(Resource runtimeDiagram, Resource entry, Group group, EvaluationContext observer);

    /**
     * Perform complete re-application of this style on the current set of
     * observed diagram items.
     * 
     * <p>
     * Must always be invoked from the canvas context thread.
     * 
     * @param context the canvas context in which the style is to be applied
     * @param diagram
     * @param group
     * @param observer profile system observer for this canvas context
     */
    void apply(Resource entry, Group group, EvaluationContext observer);

}
