/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.procedure.SetListener;


/**
 * Groups are a part of the diagram profile framework. They are used to form and
 * keep track of the group of objects on which {@link Style}s operate.
 * 
 * @author Antti Villberg
 */
public interface Group {

    /**
     * Allows styles to start tracking the set of objects (resources) listed by
     * this Group implementation through the specified {@link SetListener}.
     * 
     * @param processor graph database access handle
     * @param runtimeDiagram runtime resource of the active diagram editor
     *        instance
     * @param configuration variable access to the diagram's mapped
     *        configuration
     * @param listener the listener to notify of changes in the tracked set of
     *        objects. Usually one just delegates normal database listener
     *        events to this listener.
     */
    void trackItems(RequestProcessor processor, Resource runtimeDiagram, SetListener<Resource> listener);

}
