/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.annotations.factories.CompoundRelatedGetSetValueRuleFactory;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;

public class CompoundValueAccessor
implements IDomainAccessor<Resource, Object> {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    Resource objRelation;
    Resource objType;
    Resource valRelation;

    public CompoundValueAccessor(Resource objRelation, Resource objType, Resource valRelation) {
        this.objRelation = objRelation;
        this.objType = objType;
        this.valRelation = valRelation;
    }

    @Override
    public Object get(ReadGraph g, Resource element) throws MappingException {
        try {
            Layer0 l0 = Layer0.getInstance((ReadGraph)g);
            LOGGER.info((Object)"        CompoundValueAccessor.get");
            Collection coll = g.getStatements(element, this.objRelation);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Statement c : coll) {
                String name = (String)g.getRelatedValue(c.getObject(), l0.HasName);
                if (map.containsKey(name) && c.isAsserted(element)) continue;
                map.put(name, g.getRelatedValue(c.getObject(), this.valRelation));
            }
            return map;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean set(WriteGraph g, Resource element, Object v) throws MappingException {
        try {
            Layer0 l0 = Layer0.getInstance((ReadGraph)g);
            LOGGER.info((Object)"        CompoundValueAccessor.set");
            Map values = (Map)v;
            Collection coll = g.getStatements(element, this.objRelation);
            HashMap<String, Statement> stmMap = new HashMap<String, Statement>();
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            for (Statement c : coll) {
                String name = (String)g.getRelatedValue(c.getObject(), l0.HasName);
                if (stmMap.containsKey(name) && c.isAsserted(element)) continue;
                stmMap.put(name, c);
                valueMap.put(name, g.getRelatedValue(c.getObject(), this.valRelation));
            }
            boolean changed = false;
            for (String key : values.keySet()) {
                Resource valueResource;
                Object value = values.get(key);
                if (value.equals(valueMap.get(key))) continue;
                changed = true;
                Statement stm = (Statement)stmMap.get(key);
                if (stm == null || stm.isAsserted(element)) {
                    Resource obj = g.newResource();
                    g.claim(obj, l0.InstanceOf, this.objType);
                    g.claimLiteral(obj, l0.HasName, (Object)key);
                    g.claim(element, this.objRelation, obj);
                    stm = this.getStatement((ReadGraph)g, element, this.objRelation, obj);
                }
                Statement valueStatement = g.getPossibleStatement(stm.getObject(), this.valRelation);
                Resource valueType = CompoundRelatedGetSetValueRuleFactory.dataTypeOfClass((ReadGraph)g, value.getClass());
                if (valueStatement == null) {
                    valueResource = g.newResource();
                    g.claim(valueResource, Layer0.getInstance((ReadGraph)g).InstanceOf, null, valueType);
                    g.claim(stm.getObject(), this.valRelation, valueResource);
                    g.claimValue(valueResource, value);
                    continue;
                }
                if (!valueStatement.isAsserted(stm.getObject())) {
                    g.claimValue(valueStatement.getObject(), value);
                    continue;
                }
                valueResource = g.newResource();
                g.claim(valueResource, Layer0.getInstance((ReadGraph)g).InstanceOf, null, valueType);
                g.claim(stm.getObject(), this.valRelation, valueResource);
                g.claimValue(valueResource, value);
            }
            return changed;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    private Statement getStatement(ReadGraph g, Resource s, Resource p, Resource o) throws DatabaseException {
        for (Statement stm : g.getStatements(s, p)) {
            if (!stm.getObject().equals(o)) continue;
            return stm;
        }
        return null;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 instanceof boolean[]) {
            Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof int[]) {
            Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof float[]) {
            Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof double[]) {
            Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof byte[]) {
            Arrays.equals((byte[])o1, (byte[])o2);
        }
        return o1.equals(o2);
    }
}

