/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.rules.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.structural.StructuralResource;

public class RelatedOrderedSetElementsAccessor implements IDomainAccessor<StructuralResource, Collection<StructuralResource>> {

    static Logger LOGGER = Logger.getLogger("org.simantics.objmap");
    
	boolean deleteExtraObjects;
	boolean useTypeResource;

	public RelatedOrderedSetElementsAccessor(boolean deleteExtraObjects, boolean useTypeResource) {
        super();
        this.deleteExtraObjects = deleteExtraObjects;
        this.useTypeResource = useTypeResource;
    }

    @Override
	public Collection<StructuralResource> get(ReadGraph g, StructuralResource element) throws MappingException {
		try {
		    LOGGER.info("        RelatedOrderedSetElementsAccessor.get");
		    Resource res = getServiceResource(g, element);
		    if (res == null)
		    	return Collections.emptyList();
			List<Resource> list =  OrderedSetUtils.toList(g, res);
			List<StructuralResource> result = new ArrayList<StructuralResource>(list.size());
			for (Resource r : list) {
				result.add(new StructuralResource(g,r,element.getContext()));
			}
			return result;
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
	}
	
	@Override
	public boolean set(WriteGraph g, StructuralResource element, Collection<StructuralResource> value)
			throws MappingException {
		try {
		    LOGGER.info("        RelatedOrderedSetElementsAccessor.set");
		    Resource res = getServiceResource(g, element);
		    if (res == null)
		    	return false;
		    List<Resource> list = new ArrayList<Resource>(value.size());
		    for (StructuralResource r : value) {
		    	list.add(r.getResource());
		    }
		    return OrderedSetUtils.set(g, res, list);
		    // FIXME Implement deleteExtraObjects
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
		
	}
	
	private Resource getServiceResource(ReadGraph g, StructuralResource element) {
		if (!useTypeResource)
			return element.getResource();
		return element.getTypeResource();
	}

}
