package org.simantics.objmap.graph.schema;

import java.util.ArrayList;

import org.simantics.db.Resource;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;

public class OrderedSetSimpleLinkType<Range> extends SimpleLinkType<Range> {

	public OrderedSetSimpleLinkType(Resource domainType, Class<?> rangeType, ArrayList<IBidirectionalMappingRule<Resource, Range>> rules) {
		super(domainType, rangeType, rules);
	}

	public OrderedSetSimpleLinkType(Resource domainType, Class<?> rangeType) {
		super(domainType, rangeType);
	}
	
	public Resource createDomainElement(org.simantics.db.WriteGraph g, Range rangeElement) throws org.simantics.objmap.exceptions.MappingException {
		 try {
            if(LOGGER.isInfoEnabled())
                LOGGER.info("SimpleLinkType.createDomainElement " +
                        rangeElement.toString()
                );
            Resource result = OrderedSetUtils.create(g, domainType);
            return result;
        } catch(DatabaseException e) {
            throw new MappingException(e);
        }
	};

}
