/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.range;

import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.adapters.ValueAdapter;



public class AdaptedRangeAccessor<Range> implements IRangeAccessor<Range,Object> {
    IRangeAccessor<Range,Object> baseAccessor;
    ValueAdapter adapter;
    
    public AdaptedRangeAccessor(IRangeAccessor<Range,Object> baseAccessror,
            ValueAdapter adapter) {
        this.baseAccessor = baseAccessror;
        this.adapter = adapter;
    }

    @Override
    public Object get(Range element) throws MappingException {
        return adapter.rangeToDomain(baseAccessor.get(element));    
    }
    
    @Override
    public boolean set(Range element, Object value) throws MappingException {
        return baseAccessor.set(element, adapter.domainToRange(value));
    }
}
