/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.domain;

import java.util.Arrays;

import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.exceptions.MappingException;

/**
 * Accesses a value attached to the element by given functional relation.
 * @author Hannu Niemist�
 */
public class RelatedValueAccessor implements IDomainAccessor<Resource,Object> {

    static Logger LOGGER = Logger.getLogger("org.simantics.objmap");
    
	Resource relation;
	Resource valueType;

	public RelatedValueAccessor(Resource relation, Resource valueType) {
		this.relation = relation;
		this.valueType = valueType;
	}

	@Override
	public Object get(ReadGraph g, Resource element) throws MappingException {
		try {
		    LOGGER.info("        RelatedValueAccessor.get");
			Resource valueResource = g.getPossibleObject(element, relation);
			if(valueResource == null)
				return null;
			return g.getValue(valueResource);
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
	}
	
	@Override
	public boolean set(WriteGraph g, Resource element, Object value)
			throws MappingException {
		try {
		    LOGGER.info("        RelatedValueAccessor.set");
		    Statement valueStatement = g.getPossibleStatement(element, relation);
			if(valueStatement == null) {
				if(value == null)
					return false;
				Resource valueResource = g.newResource();
				g.claim(valueResource, Layer0.getInstance(g).InstanceOf, null,
						valueType);
				g.claim(element, relation, valueResource);
				g.claimValue(valueResource, value);				
				return true;
			}
			else {
				if(value == null) {
					if (!valueStatement.isAsserted(element)) {
						g.deny(valueStatement.getObject());
						return true;
					} else {
						return false;
					}
				}				
				Object currentValue = g.getValue(valueStatement.getObject());
				if(equals(currentValue,value))
					return false;
				if (!valueStatement.isAsserted(element))
					g.claimValue(valueStatement.getObject(), value);
				else {
					Resource valueResource = g.newResource();
					g.claim(valueResource, Layer0.getInstance(g).InstanceOf, null,
							valueType);
					g.claim(element, relation, valueResource);
					g.claimValue(valueResource, value);
				}
				return true;
			}
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
		
	}
	
	private boolean equals(Object o1, Object o2) {
		if (o1 instanceof boolean[])
			Arrays.equals((boolean[])o1,(boolean[])o2);
		if (o1 instanceof int[])
			Arrays.equals((int[])o1,(int[])o2);
		if (o1 instanceof float[])
			Arrays.equals((float[])o1,(float[])o2);
		if (o1 instanceof double[])
			Arrays.equals((double[])o1,(double[])o2);
		if (o1 instanceof byte[])
			Arrays.equals((byte[])o1,(byte[])o2);
		return o1.equals(o2);
		
	}

}
