/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.domain;

import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;

/**
 * Accesses a resource attached to the element by given functional relation.
 * @author Hannu Niemist
 */
public class RelatedObjectAccessor implements IDomainAccessor<Resource,Resource> {

    static Logger LOGGER = Logger.getLogger("org.simantics.objmap");
    
	Resource relation;
	
	public RelatedObjectAccessor(Resource relation) {
		this.relation = relation;
	}

	@Override
	public Resource get(ReadGraph g, Resource element) throws MappingException {
		try {
		    LOGGER.info("        RelatedObjectAccessor.get");
			return g.getPossibleObject(element, relation);
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
	}
	
	@Override
	public boolean set(WriteGraph g, Resource element, Resource value)
			throws MappingException {
		try {
		    LOGGER.info("        RelatedObjectAccessor.set");
		    Resource resource = g.getPossibleObject(element, relation);
			if(resource == null) {
			    if(value == null)
			        return false;
			    g.claim(element, relation, value);
			    return true;
			}
			else if(resource.equals(value))
			    return false;
			else {
			    g.deny(element, relation);
			    if(value != null)
			        g.claim(element, relation, value);
			    return true;
			}
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
		
	}

}
