/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.domain;

import java.util.Arrays;
import java.util.Collection;

import org.apache.log4j.Logger;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Static utility methods for rule implementations.
 * @author Hannu Niemist
 */
public class MappingUtils {

    static Logger LOGGER = Logger.getLogger("org.simantics.objmap");
    
    /**
     * Adds and removes statements to/from the database so that <code>objects</code>
     * will be exactly the objects connected to <code>subject</code> by <code>predicate</code>.
     * Returns true if the method made modifications to the database.
     */
	public static boolean synchronizeStatements(WriteGraph g, Resource subject, Resource predicate, Resource[] objects,
	        boolean deleteExtraObjects) 
		throws DatabaseException {
		Collection<Resource> currentObjects0 = g.getObjects(subject, predicate);
		Resource[] currentObjects = currentObjects0.toArray(new Resource[currentObjects0.size()]);
		
		Arrays.sort(objects);
		Arrays.sort(currentObjects);
		
		boolean modified = false;
		int i=0, j=0;	
		if(currentObjects.length > 0 && objects.length > 0)
    		while(true) {
    			int cmp = currentObjects[i].compareTo(objects[j]);
    			if(cmp < 0) {
    			    LOGGER.info("            remove statement");
    			    if(deleteExtraObjects)
    			        g.deny(currentObjects[i]);
    			    else
    			        g.denyStatement(subject, predicate, currentObjects[i]);    				
    				modified = true;
    				++i;
    				if(i >= currentObjects.length)
    					break;
    			}
    			else if(cmp > 0) {
    			    LOGGER.info("            add statement");
    				g.claim(subject, predicate, objects[j]);
    				modified = true;
    				++j;
    				if(j >= objects.length)
    					break;
    			}
    			else {
    				++i; ++j;
    				if(i >= currentObjects.length)
    					break;
    				if(j >= objects.length)
    					break;
    			}
    		}
		while(i < currentObjects.length) {
		    if(deleteExtraObjects)
                g.deny(currentObjects[i]);
            else
                g.denyStatement(subject, predicate, currentObjects[i]);
			modified = true;
			++i;
		}
		while(j < objects.length) {
			g.claim(subject, predicate, objects[j]);
			modified = true;
			++j;
		}
		return modified;
	}

}
