/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.annotations.factories.CompoundRelatedGetSetValueRuleFactory;

/**
 * 
 * @author Marko Luukkainen
 */
public class CompoundValueAccessor implements IDomainAccessor<Resource,Object> {

    static Logger LOGGER = Logger.getLogger("org.simantics.objmap");
    
	Resource objRelation;
	Resource objType;
	Resource valRelation;

	public CompoundValueAccessor(Resource objRelation, Resource objType, Resource valRelation) {
		this.objRelation = objRelation;
		this.objType = objType;
		this.valRelation = valRelation;
	}

	@Override
	public Object get(ReadGraph g, Resource element) throws MappingException {
		try {
			Layer0 l0 = Layer0.getInstance(g);
		    LOGGER.info("        CompoundValueAccessor.get");
		    Collection<Statement> coll = g.getStatements(element, objRelation);
		    Map<String,Object> map = new HashMap<String, Object>();
		    for (Statement c : coll) {
		    	String name = g.getRelatedValue(c.getObject(), l0.HasName);
		    	if (!map.containsKey(name) || !c.isAsserted(element))
		    		map.put(name, g.getRelatedValue(c.getObject(), valRelation));
		    }
			return map;
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
	}
	
	@Override
	public boolean set(WriteGraph g, Resource element, Object v)
			throws MappingException {
		try {
			Layer0 l0 = Layer0.getInstance(g);
		    LOGGER.info("        CompoundValueAccessor.set");
		    @SuppressWarnings("unchecked")
		    Map<String,Object> values = (Map<String, Object>)v;
		    
		    Collection<Statement> coll = g.getStatements(element, objRelation);
		    Map<String,Statement> stmMap = new HashMap<String, Statement>();
		    Map<String,Object> valueMap = new HashMap<String, Object>();
		    for (Statement c : coll) {
		    	String name = g.getRelatedValue(c.getObject(), l0.HasName);
		    	if (!stmMap.containsKey(name) || !c.isAsserted(element)) {
		    		stmMap.put(name, c);
		    		valueMap.put(name, g.getRelatedValue(c.getObject(), valRelation));
		    	}
		    }
		    boolean changed = false;
		    for (String key : values.keySet()) {
		    	Object value = values.get(key);
		    	if (value.equals(valueMap.get(key)))
		    		continue;
		    	changed = true;
		    	Statement stm = stmMap.get(key);
		    	if (stm == null || stm.isAsserted(element)) {
		    		Resource obj = g.newResource();
		    		g.claim(obj, l0.InstanceOf, objType);
		    		g.claimLiteral(obj, l0.HasName, key);
		    		g.claim(element, objRelation, obj);
		    		stm = getStatement(g, element, objRelation, obj);
		    	}
		    	
		    	Statement valueStatement = g.getPossibleStatement(stm.getObject(), valRelation);
		    	Resource valueType = CompoundRelatedGetSetValueRuleFactory.dataTypeOfClass(g, value.getClass());
				if(valueStatement == null) {
					
					Resource valueResource = g.newResource();
					g.claim(valueResource, Layer0.getInstance(g).InstanceOf, null,	valueType);
					g.claim(stm.getObject(), valRelation, valueResource);
					g.claimValue(valueResource, value);				
				} else {
									
					
					if (!valueStatement.isAsserted(stm.getObject()))
						g.claimValue(valueStatement.getObject(), value);
					else {
						Resource valueResource = g.newResource();
						g.claim(valueResource, Layer0.getInstance(g).InstanceOf, null,
								valueType);
						g.claim(stm.getObject(), valRelation, valueResource);
						g.claimValue(valueResource, value);
					}
				}
		    }
		    return changed;
		    
		} catch (DatabaseException e) {
			throw new MappingException(e);
		}
		
	}
	
	private Statement getStatement(ReadGraph g, Resource s, Resource p, Resource o) throws DatabaseException{
		for (Statement stm : g.getStatements(s, p)) {
			if (stm.getObject().equals(o))
				return stm;
		}
		return null;
	}
	
	private boolean equals(Object o1, Object o2) {
		if (o1 instanceof boolean[])
			Arrays.equals((boolean[])o1,(boolean[])o2);
		if (o1 instanceof int[])
			Arrays.equals((int[])o1,(int[])o2);
		if (o1 instanceof float[])
			Arrays.equals((float[])o1,(float[])o2);
		if (o1 instanceof double[])
			Arrays.equals((double[])o1,(double[])o2);
		if (o1 instanceof byte[])
			Arrays.equals((byte[])o1,(byte[])o2);
		return o1.equals(o2);
		
	}

}
