/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules;

import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;


/**
 * A rule that synchronizes values between domain and
 * range accessors.
 * @author Hannu Niemist
 */
public class ValueRule<Domain, Range> implements IBidirectionalMappingRule<Domain, Range> {
    
    static Logger LOGGER = Logger.getLogger("org.simantics.objmap");
    
	IDomainAccessor<Domain,Object> domainAccessor;
	IRangeAccessor<Range,Object> rangeAccessor;
	
	public ValueRule(IDomainAccessor<Domain,Object> domainAccessor,
			IRangeAccessor<Range,Object> rangeAccessor) {
		this.domainAccessor = domainAccessor;
		this.rangeAccessor = rangeAccessor;
	}

	@Override
	public boolean updateDomain(WriteGraph g, IBackwardMapping<Domain, Range> map,
			Domain domainElement, Range rangeElement)
			throws MappingException {
        LOGGER.info("    ValueRule.updateDomain");	    
		Object value = rangeAccessor.get(rangeElement);
		return domainAccessor.set(g, domainElement, value);
	}

	@Override
	public boolean updateRange(ReadGraph g, IForwardMapping<Domain, Range> map,
			Domain domainElement, Range rangeElement)
			throws MappingException {
        LOGGER.info("    ValueRule.updateRange");
		Object value = domainAccessor.get(g, domainElement);
		return rangeAccessor.set(rangeElement, value);
	}	
	
	public void createDomain(WriteGraph g, IBackwardMapping<Domain,Range> map, Domain domainElement, Range rangeElement) throws MappingException {
		updateDomain(g, map, domainElement, rangeElement);
	};
	public void createRange(ReadGraph g, IForwardMapping<Domain,Range> map, Domain domainElement, Range rangeElement) throws MappingException {
		updateRange(g, map, domainElement, rangeElement);
	};
}


