/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.CompoundRelatedGetValue;
import org.simantics.objmap.graph.annotations.CompoundRelatedSetValue;
import org.simantics.objmap.graph.rules.ValueRule;
import org.simantics.objmap.graph.rules.domain.CompoundValueAccessor;
import org.simantics.objmap.graph.rules.factory.IGetSetRuleFactory;
import org.simantics.objmap.graph.rules.range.CompoundGetSetValueAccessor;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;

/**
 * Rule factory for mapped value using Getter/Setter-methods.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class CompoundRelatedGetSetValueRuleFactory<Range> implements IGetSetRuleFactory<Resource,Range> {
	
	@Override
	public IBidirectionalMappingRule<Resource, Range> create(ReadGraph g, Annotation annotation,
			Method getter, Method setter)
			throws DatabaseException {
		CompoundRelatedGetValue getterAnn = (CompoundRelatedGetValue)annotation;
		
//		Class<? extends ValueAdapter> adapterClass = getterAnn.adapter();
		IRangeAccessor<Range,Object> rangeAccessor = new CompoundGetSetValueAccessor<Range,Object>(getter, setter);
//        Resource valueType;
//        if (adapterClass == IdentityAdapter.class) {
//            valueType = dataTypeOfClass(g, getter.getReturnType());
//        } else {
//        	try{
//        		 ValueAdapter adapter = adapterClass.newInstance();
//                 rangeAccessor = new AdaptedRangeAccessor<Range>(rangeAccessor, adapter);
//                 valueType = adapter.rangeTypeToDomainType(g, getter.getReturnType());
//             } catch (InstantiationException e) {
//                 throw new RuntimeException(e);
//             } catch (IllegalAccessException e) {
//                 throw new RuntimeException(e);
//             }
//        }
		return new ValueRule<Resource,Range>(new CompoundValueAccessor(g.getResource(getterAnn.objRelation()),
																	   g.getResource(getterAnn.objType()),
																	   g.getResource(getterAnn.valRelation())),
					rangeAccessor);
	}
	
	@Override
	public boolean isSetter(Annotation getterAnnotation, Annotation annotation) {
		CompoundRelatedGetValue getterAnn = (CompoundRelatedGetValue)getterAnnotation;
		CompoundRelatedSetValue setterAnn = (CompoundRelatedSetValue)annotation;
		return getterAnn.objRelation().equals(setterAnn.value());
	}
	
	public static Resource dataTypeOfClass(ReadGraph g, Class<?> clazz) {
        Layer0 b = Layer0.getInstance(g);
        if(clazz.equals(Double.class) || clazz.equals(double.class))
            return b.Double;
        else if(clazz.equals(String.class))
            return b.String;
        else if(clazz.equals(Integer.class) || clazz.equals(int.class))
            return b.Integer;
        else if(clazz.equals(Float.class) || clazz.equals(float.class))
            return b.Float;
        else if(clazz.equals(Boolean.class) || clazz.equals(boolean.class))
            return b.Boolean;
        else if(clazz.equals(Long.class) || clazz.equals(long.class))
            return b.Long;
        else if(clazz.equals(Byte.class) || clazz.equals(byte.class))
            return b.Byte;
        
        else if(clazz.equals(double[].class))
            return b.DoubleArray;
        else if(clazz.equals(int[].class))
            return b.IntegerArray;
        else if(clazz.equals(byte[].class))
            return b.ByteArray;
        else if(clazz.equals(float[].class))
            return b.FloatArray;
        else if(clazz.equals(boolean[].class))
            return b.BooleanArray;
        else if(clazz.equals(String[].class))
            return b.StringArray;
        else if(clazz.equals(long[].class))
            return b.LongArray;
        else {
        	System.out.println("Couldn't find a data type for " + clazz);
            return null;
        }
    }

}
