/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.requests;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.IFilter;
import org.simantics.modeling.requests.Node;
import org.simantics.scl.runtime.function.Function1;

public class Nodes {
    public static Collection<Node> breadthFirstFlatten(IFilter filter, Collection<Node> roots) {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayList<Node> sortedRoots = new ArrayList<Node>(roots);
        Collections.sort(sortedRoots);
        ArrayDeque<Node> todo = new ArrayDeque<Node>(sortedRoots);
        while (!todo.isEmpty()) {
            Node n = (Node)todo.removeFirst();
            ArrayList<Node> sorted = new ArrayList<Node>(n.getChildren());
            Collections.sort(sorted);
            todo.addAll(sorted);
            if (filter != null && !filter.select((Object)n)) continue;
            result.add(n);
        }
        return result;
    }

    public static Collection<Node> depthFirstFlatten(IFilter filter, Collection<Node> roots, Comparator<? super Node> comparator) {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayList<Node> sortedRoots = new ArrayList<Node>(roots);
        Collections.sort(sortedRoots, comparator);
        for (Node n : sortedRoots) {
            Nodes.depthFirstFlattenRec(filter, comparator, n, result);
        }
        return result;
    }

    private static Collection<Node> depthFirstFlattenRec(IFilter filter, Comparator<? super Node> comparator, Node n, Collection<Node> result) {
        Collection<Node> children;
        if (filter == null || filter.select((Object)n)) {
            result.add(n);
        }
        if ((children = n.getChildren()).isEmpty()) {
            return result;
        }
        ArrayList<Node> sorted = new ArrayList<Node>(children);
        Collections.sort(sorted, comparator);
        for (Node child : sorted) {
            Nodes.depthFirstFlattenRec(filter, comparator, child, result);
        }
        return result;
    }

    public static boolean walkTree(Function1<Node, Boolean> filter, Collection<Node> roots) {
        ArrayList<Node> sortedRoots = new ArrayList<Node>(roots);
        Collections.sort(sortedRoots);
        for (Node n : sortedRoots) {
            if (Nodes.walkTreeRec(filter, n)) continue;
            return false;
        }
        return true;
    }

    private static boolean walkTreeRec(Function1<Node, Boolean> filter, Node n) {
        if (!((Boolean)filter.apply((Object)n)).booleanValue()) {
            return false;
        }
        Collection<Node> children = n.getChildren();
        if (!children.isEmpty()) {
            ArrayList<Node> sorted = new ArrayList<Node>(children);
            Collections.sort(sorted);
            for (Node child : sorted) {
                if (Nodes.walkTreeRec(filter, child)) continue;
                return false;
            }
        }
        return true;
    }
}

