/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.strings.AlphanumComparator;

public class Node
implements Comparable<Node> {
    public static final Comparator<Node> CASE_INSENSITIVE_COMPARATOR = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName());
        }
    };
    private final Node parent;
    private final List<Node> children = new ArrayList<Node>();
    private final Resource diagram;
    private final ResourceArray definingResource;
    private final String name;
    private PageDesc pageDesc;
    private String RVI;

    public Node(Node parent, String name, Resource diagram, Resource ... definingResources) {
        if (definingResources.length == 0) {
            throw new IllegalArgumentException("must provide at least one defining resource");
        }
        this.parent = parent;
        this.name = name;
        this.diagram = diagram;
        this.definingResource = new ResourceArray(definingResources);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public Node getParent() {
        return this.parent;
    }

    public Resource getDiagramResource() {
        return this.diagram;
    }

    public ResourceArray getDefiningResources() {
        return this.definingResource;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return (this.parent != null ? this.parent : "") + "/" + this.name + this.definingResource;
    }

    public void addChild(Node child) {
        this.children.add(child);
    }

    public void removeChild(Node child) {
        this.children.remove(child);
    }

    public Collection<Node> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public void setPageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
    }

    public void setRVI(String RVI2) {
        this.RVI = RVI2;
    }

    public String getRVI() {
        return this.RVI;
    }

    public PageDesc getPageDesc() {
        return this.pageDesc;
    }

    @Override
    public int compareTo(Node o) {
        int ret = this.name.compareTo(o.name);
        return ret;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.diagram == null ? 0 : this.diagram.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.definingResource == null ? 0 : this.definingResource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.diagram == null ? other.diagram != null : !this.diagram.equals(other.diagram)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.definingResource == null ? other.definingResource != null : !this.definingResource.equals((Object)other.definingResource));
    }
}

