/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.migration;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.WriteInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.utils.logging.TimeLogger;

public class LayerCleanupMigrationStep
implements MigrationStep {
    public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        TimeLogger.log((String)"LayerCleanupMigrationStep");
        final Resource indexRoot = MigrationUtils.getResource((IProgressMonitor)monitor, (Session)session, (MigrationState)state);
        if (indexRoot == null) {
            return;
        }
        monitor.setTaskName("Cleanup layers migration - remove layer assignments");
        session.sync((WriteInterface)new DelayedWriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                for (Resource model : graph.getObjects(indexRoot, L0.ConsistsOf)) {
                    List<Resource> elements = ModelingUtils.searchByType((ReadGraph)graph, model, DIA.Element);
                    for (Resource element : Layer0Utils.sortByCluster((ReadGraph)graph, elements)) {
                        for (Statement stm : graph.getStatements(element, DIA.IsFocusable)) {
                            graph.deny(stm);
                        }
                        for (Statement stm : graph.getStatements(element, DIA.IsVisible)) {
                            graph.deny(stm);
                        }
                    }
                }
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add("Removing deprecated layer assignments from the model."));
            }
        });
        monitor.setTaskName("Cleanup layers migration - remove layers");
        session.sync((WriteInterface)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                for (Resource model : graph.getObjects(indexRoot, L0.ConsistsOf)) {
                    for (Resource diagram : ModelingUtils.searchByType((ReadGraph)graph, model, DIA.Composite)) {
                        for (Resource layer : graph.getObjects(diagram, DIA.HasLayer)) {
                            RemoverUtil.remove((WriteGraph)graph, (Resource)layer);
                        }
                    }
                }
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add("Removing deprecated layers from the model."));
            }
        });
        TimeLogger.log((String)"LayerCleanupMigrationStep done");
    }
}

