/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.AllowedConnectionTypes;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.Triple;

public class MigrateModel {
    public int instanceCount = 0;
    public Set<Resource> activeModels = new THashSet();
    public List<Triple<String, NamedResource, Collection<MigrationOperation>>> instances = new ArrayList<Triple<String, NamedResource, Collection<MigrationOperation>>>();
    public List<MigrationOperation> sortedShownInstances = Collections.emptyList();

    public static class MigrationOperation {
        public NamedResource instanceToMigrate;
        public NamedResource targetType;
        public NamedResource targetSymbol;

        public MigrationOperation(NamedResource nr, NamedResource targetType, NamedResource targetSymbol) {
            this.instanceToMigrate = nr;
            this.targetType = targetType;
            this.targetSymbol = targetSymbol;
        }

        public String toString() {
            return this.instanceToMigrate.getName();
        }

        public String getDescription(ReadGraph graph) throws DatabaseException {
            String sourceURI = graph.getPossibleURI(this.instanceToMigrate.getResource());
            if (sourceURI == null) {
                sourceURI = NameUtils.getSafeName((ReadGraph)graph, (Resource)this.instanceToMigrate.getResource());
            }
            sourceURI = sourceURI.replace("http://Projects/Development%20Project/", "");
            if (this.targetSymbol != null) {
                String targetURI = graph.getURI(this.targetSymbol.getResource());
                return String.valueOf(URIStringUtils.unescape((String)sourceURI)) + " into " + URIStringUtils.unescape((String)targetURI);
            }
            String targetURI = graph.getURI(this.targetType.getResource());
            return String.valueOf(URIStringUtils.unescape((String)sourceURI)) + " into " + URIStringUtils.unescape((String)targetURI);
        }

        private Resource getPossibleReplacement(ReadGraph graph, Resource type, Resource predicate) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            String name = (String)graph.getPossibleRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
            if (name == null) {
                return null;
            }
            Resource child = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)type, (String)name);
            if (child != null) {
                return child;
            }
            for (Resource r : graph.getObjects(type, L0.DomainOf)) {
                String rName = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
                if (!name.equals(rName)) continue;
                return r;
            }
            return null;
        }

        public String replace(WriteGraph graph, Resource instanceToMigrate, Resource type) throws DatabaseException {
            Resource replacement;
            Resource predicate;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Collection currentTypes = graph.getPrincipalTypes(instanceToMigrate);
            if (currentTypes.size() == 1 && currentTypes.contains(type)) {
                return null;
            }
            StringBuilder problems = new StringBuilder();
            for (Statement stm : graph.getStatements(instanceToMigrate, L0.IsWeaklyRelatedTo)) {
                Collection replacementConnectionTypes;
                THashSet replacementSet;
                String name;
                predicate = stm.getPredicate();
                if (stm.isAsserted(instanceToMigrate)) continue;
                if (graph.isInstanceOf(predicate, STR.Property)) {
                    String replacementValueType;
                    replacement = this.getPossibleReplacement((ReadGraph)graph, type, predicate);
                    if (replacement == null) continue;
                    if (!graph.isInstanceOf(replacement, STR.Property)) {
                        name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                        problems.append(" " + name + " was a property in the source type\n");
                        continue;
                    }
                    String sourceValueType = (String)graph.getPossibleRelatedValue(predicate, L0.RequiresValueType, (Binding)Bindings.STRING);
                    if (!ObjectUtils.objectEquals((Object)sourceValueType, (Object)(replacementValueType = (String)graph.getPossibleRelatedValue(replacement, L0.RequiresValueType, (Binding)Bindings.STRING)))) {
                        String name2 = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                        problems.append(" value types for property " + name2 + " differ (" + sourceValueType + " vs. " + replacementValueType + ")\n");
                        continue;
                    }
                }
                if (!graph.isInstanceOf(predicate, STR.ConnectionRelation)) continue;
                replacement = this.getPossibleReplacement((ReadGraph)graph, type, predicate);
                if (replacement == null) {
                    name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                    problems.append(" used connection point " + name + " has been removed from target type\n");
                    continue;
                }
                if (!graph.isInstanceOf(replacement, STR.ConnectionRelation)) {
                    name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                    problems.append(" " + name + " was a connection point in the source type\n");
                    continue;
                }
                Collection sourceConnetionTypes = (Collection)graph.syncRequest((Read)new AllowedConnectionTypes(predicate));
                THashSet sourceSet = new THashSet(sourceConnetionTypes);
                if (sourceSet.equals(replacementSet = new THashSet(replacementConnectionTypes = (Collection)graph.syncRequest((Read)new AllowedConnectionTypes(replacement))))) continue;
                String name3 = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                problems.append(" allowed connection types for connection point " + name3 + " differ (" + NameUtils.getSafeName((ReadGraph)graph, (Collection)sourceSet) + " vs. " + NameUtils.getSafeName((ReadGraph)graph, (Collection)replacementSet) + ")\n");
            }
            if (problems.length() > 0) {
                return problems.toString();
            }
            for (Statement stm : graph.getStatements(instanceToMigrate, L0.IsWeaklyRelatedTo)) {
                predicate = stm.getPredicate();
                if (stm.isAsserted(instanceToMigrate)) continue;
                if (L0.InstanceOf.equals(predicate)) {
                    graph.deny(stm);
                    graph.claim(instanceToMigrate, L0.InstanceOf, type);
                }
                if (!graph.isInstanceOf(predicate, STR.Property) && !graph.isInstanceOf(predicate, STR.ConnectionRelation)) continue;
                replacement = this.getPossibleReplacement((ReadGraph)graph, type, predicate);
                graph.deny(stm);
                if (replacement == null) continue;
                graph.claim(stm.getSubject(), replacement, stm.getObject());
            }
            return null;
        }

        public String perform(WriteGraph graph) throws DatabaseException {
            Resource instance = this.instanceToMigrate.getResource();
            Resource type = this.targetType.getResource();
            Resource symbol = this.targetSymbol != null ? this.targetSymbol.getResource() : null;
            String result = this.replace(graph, instance, type);
            if (result != null) {
                return result;
            }
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource element = graph.getPossibleObject(instance, MOD.ComponentToElement);
            if (element == null) {
                return null;
            }
            Resource targetSymbol = symbol;
            if (targetSymbol == null) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                Resource currentSymbol = graph.getPossibleType(element, DIA.Element);
                if (currentSymbol != null) {
                    String currentSymbolName = (String)graph.getRelatedValue(currentSymbol, L0.HasName, (Binding)Bindings.STRING);
                    targetSymbol = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)type, (Resource)DIA.ElementClass, (String)currentSymbolName);
                    if (targetSymbol == null) {
                        return "Did not find symbol '" + currentSymbolName + "' from target type.\n";
                    }
                } else {
                    return null;
                }
            }
            return this.replace(graph, element, targetSymbol);
        }
    }
}

