/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class SelectedModelBatchIssueSources extends ResourceRead<Collection<Resource>> {

    public SelectedModelBatchIssueSources(Resource resource) {
        super(resource);
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	IssueResource ISSUE = IssueResource.getInstance(graph);
    	ArrayList<Resource> result = new ArrayList<Resource>();
    	for(Resource issueSource : graph.sync(new ObjectsWithType(resource, L0.ConsistsOf, ISSUE.IssueSource))) {
    		if(graph.hasStatement(issueSource,  ISSUE.IssueSource_Selected)) result.add(issueSource);
    	}
    	return result;
    }

}
