/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.Set;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryAsyncRead;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.issues.Severity;
import org.simantics.issues.ontology.IssueResource;

/**
 * @author Tuukka Lehtonen
 */
public class MaxIssueSeverityRecursive extends TernaryAsyncRead<Resource, Resource, Set<Resource>, Severity> {

    public MaxIssueSeverityRecursive(Resource resource, Resource childRelation, Set<Resource> typesToRecurse) {
        super(resource, childRelation, typesToRecurse);
    }

//    @Override
//    public Severity perform(ReadGraph graph) throws DatabaseException {
//        Layer0 L0 = Layer0.getInstance(graph);
//        IssueResource ISSUE = IssueResource.getInstance(graph);
//        //System.out.println("severity: " + NameUtils.getSafeName(graph, resource));
//        Collection<Resource> issues = graph.getObjects(resource, ISSUE.IsIssueContextOf);
//        if (issues.isEmpty()) {
//            // This content does not have directly attached issues, try to look
//            // for some in the child components.
//            return graph.syncRequest(new ChildMaxIssueSeverity(resource, L0.ConsistsOf));
//        }
//
//        Severity maxSeverity = graph.syncRequest(new MaxIssueSeveritySingle(resource));
//        if (maxSeverity == null)
//            maxSeverity = graph.syncRequest(new ChildMaxIssueSeverity(resource, L0.ConsistsOf));
//
//        return maxSeverity;
//    }

    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure) {
        IssueResource ISSUE = graph.getService(IssueResource.class);
        //System.out.println(getClass().getSimpleName() + ": " + parameter);

        graph.forEachObject(parameter, ISSUE.Issue_HasContext_Inverse, new AsyncMultiProcedure<Resource>() {
            volatile int issues = 0;
            @Override
            public void execute(AsyncReadGraph graph, Resource result) {
                ++issues;
            }
            @Override
            public void finished(AsyncReadGraph graph) {
                if (issues == 0) {
                    // This content does not have directly attached issues, try to look
                    // for some in the child components.
                    graph.asyncRequest(new ChildMaxIssueSeverity(parameter, parameter2, parameter3), procedure);
                } else {
                    // Try local issues first
                    graph.asyncRequest(new MaxIssueSeveritySingle(parameter), new AsyncProcedure<Severity>() {
                        @Override
                        public void execute(AsyncReadGraph graph, Severity maxSeverity) {
                            if (maxSeverity == null)
                                // No severity for local issues, try children next.
                                graph.asyncRequest(new ChildMaxIssueSeverity(parameter, parameter2, parameter3), procedure);
                            else
                                procedure.execute(graph, maxSeverity);
                        }
                        @Override
                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                            procedure.exception(graph, throwable);
                        }
                    });
                }
            }
            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

}
