package org.simantics.issues.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.Issue;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.issues.common.DependencyIssueValidator2.Contexts;
import org.simantics.issues.common.DependencyIssueValidator2.DependencyIssueDescriptions;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class DependencyIssueSynchronizer2 extends WriteRequest {

	public static final boolean DEBUG = false;
	
	private Resource resource;
	private Resource source;

	public DependencyIssueSynchronizer2(Resource resource, Resource source) {
		this.resource = resource;
		this.source = source;
	}

	@Override
	public void perform(WriteGraph graph) throws DatabaseException {

		if(DEBUG) System.err.println("Running DependencySynchronizer for " + resource);

		Set<Issue> existing = graph.syncRequest(new DependencyIssueDescriptions(source, resource), TransientCacheListener.<Set<Issue>>instance());
		Set<Issue> contexts = Collections.emptySet();
		
		if(graph.hasStatement(resource)) {
			contexts = graph.syncRequest(new Contexts(source, resource), TransientCacheListener.<Set<Issue>>instance());
		}
		
		if(!existing.equals(contexts)) {
		
			Set<Issue> added = new HashSet<Issue>(contexts);
			Set<Issue> removed = new HashSet<Issue>(existing);
			added.removeAll(existing);
			removed.removeAll(contexts);

			for(Issue add : added) {
				add.write(graph, source);
			}
			for(Issue remove : removed) {
				Resource issue = graph.sync(new IssueByList(source, remove));
				if (issue == null)
					// FIXME: when can this happen and what should be done in this case?
					continue;
				graph.deny(issue, Layer0.getInstance(graph).PartOf);
				graph.deny(source, IssueResource.getInstance(graph).IssueSource_Manages, issue);
				RemoverUtil.remove(graph, issue);
			}
			
		}

	}

}