package org.simantics.issues.common;

import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;

public class All {
	
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String defaultDescription(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	return context.getParent(graph).getLabel(graph);
    }
    
    @SCLValue(type = "a -> b -> c")
    public static Object dependencyBaseRealizationFunction(Object _graph, Object _model) throws DatabaseException {
//        ReadGraph graph = (ReadGraph)_graph;
        Resource model = (Resource)_model;
        return model;
//        SimulationResource SIMU = SimulationResource.getInstance(graph);
//        if(graph.isInstanceOf(model, SIMU.Model))
//            return graph.getSingleObject(model, SimulationResource.getInstance(graph).HasConfiguration);
//        else return null;

    }
    
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String standardIssueSeverity(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	IssueResource ISSUE = IssueResource.getInstance(graph);
    	Resource issue = property.getParent(graph).getRepresents(graph);
    	Resource severity = graph.getPossibleObject(issue, ISSUE.Issue_HasSeverity);
    	if (severity == null)
    		return "Undefined";
    	return graph.getPossibleRelatedValue(severity, L0.HasName, Bindings.STRING);
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String standardIssueResource(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	List<Resource> contexts = IssueUtils.getContextsForProperty(graph, property);
    	if(contexts.isEmpty()) return "";
    	Resource context = contexts.get(0);
    	String name = graph.getPossibleRelatedValue(context, L0.HasName, Bindings.STRING);
    	if((name != null && !name.isEmpty())) return name;
    	if(!graph.hasStatement(context)) return "Removed - please run batch validations";
    	return context.toString();
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> String")
    public static String standardIssuePath(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	List<Resource> contexts = IssueUtils.getContextsForProperty(graph, property);
    	if(contexts.isEmpty()) return "";
    	Resource parent = graph.getPossibleObject(contexts.get(0), L0.PartOf);
    	if(parent == null) return "";
    	Resource issueRoot = Variables.getPossibleIndexRoot(graph, property);
    	if(issueRoot == null) return "";
    	Resource contextRoot = graph.sync(new PossibleIndexRoot(parent));
    	if(contextRoot == null) return "";
    	if(issueRoot.equals(contextRoot)) {
        	String uri = graph.getURI(parent);
        	String contextURI = graph.getURI(contextRoot);
        	return IssueUtils.pathString(uri, contextURI.length()+1);
    	} else {
        	String uri = graph.getURI(parent);
        	String modelURI = graph.getURI(graph.getRootLibrary());
    		return IssueUtils.pathString(uri, modelURI.length()+1);
    	}
    }
     
}
