/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.simantics.graphviz.Graph;

public abstract class AbstractGraphvizEditorPart extends EditorPart {

    GraphvizComponent component;
    
    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public void init(IEditorSite site, IEditorInput input)
        throws PartInitException {
        setSite(site);
        setInput(input);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void createPartControl(Composite parent) {       
        component = new GraphvizComponent(parent, 0);
    }
    
	/**
	 * Sets a new graph to be drawn. This operation may take a while. It can
	 * be called from any thread.
	 * @param graph
	 */
    public void setGraph(Graph graph) {
    	component.setGraph(graph);
    }
    
    public void setGraph(Graph graph, String algorithm) {
    	component.setGraph(graph, algorithm);
    }

    /**
	 * Sets a new graph to be drawn. The graph is layouted in a Eclipse job.
	 * The component is redrawn after the layout is complete.
	 * @param graph
	 */
    public void asyncSetGraph(final Graph graph) {
    	Job job = new Job("Layouting a graph") {

			@Override
			protected IStatus run(IProgressMonitor monitor) {
				setGraph(graph);
				return Status.OK_STATUS;
			}
    		
    	};
    	job.schedule();
    }
    
    @Override
    public void setFocus() {
        if(component != null)
        	component.requestFocus();
    }

}
