/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.handler;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ISelectionUtils;


/**
 * @author Tuukka Lehtonen
 */
public class Delete extends AbstractHandler {

    protected final String virtualGraphId;
	
    public Delete() {
    	virtualGraphId = "experiments";
    }
    
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Session session = Simantics.peekSession();
        if (session == null)
            return null;
        ISelection selection = HandlerUtil.getCurrentSelection(event);
        final List<Resource> resources = ISelectionUtils.getPossibleKeys(selection, SelectionHints.KEY_MAIN, Resource.class);
        final VirtualGraph vg = virtualGraphId == null ? null :
            session.getService(VirtualGraphSupport.class).getWorkspacePersistent(virtualGraphId);

        session.asyncRequest(new WriteRequest(vg) {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
            	Layer0 L0 = Layer0.getInstance(graph);
            	EventResource EVENT = EventResource.getInstance(graph);
            	Set<Resource> eventLogs = new HashSet<Resource>();
            	for (Resource event : resources) {
                	if (graph.isInstanceOf(event, EVENT.Event)) {
                		Resource slice = graph.getPossibleObject(event, L0.PartOf);
                		if(slice != null) {
                			Resource eventlog =	graph.getPossibleObject(slice, L0.PartOf);
                    		if (eventlog != null) eventLogs.add(eventlog);
                		}
                	}
            		graph.deny( event );
            	}
            	for (Resource eventlog : eventLogs) {
            		if (graph.isInstanceOf(eventlog, EVENT.EventLog))
            		    graph.syncRequest( new CorrectMilestoneLabelsAction(eventlog, vg) );
            	}
            }
        }, new Callback<DatabaseException>() {
            @Override
            public void run(DatabaseException e) {
                if (e != null) Logger.defaultLogError(e);
            }
        });
        return null;
    }

}
