package org.simantics.document.ui.wizard;

import java.io.File;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.simantics.db.Resource;
import org.simantics.document.ui.graphfile.FileDocumentUtil;

public abstract  class FileDocumentImportWizard extends Wizard{
	
	FileSelectionPage fileSelectionPage;
	
	public FileDocumentImportWizard(Resource lib) {
		setWindowTitle("Document File import");
		setNeedsProgressMonitor(false);
	}
	
	public abstract Resource getLib();
	
	public abstract Resource getRel();
	
	@Override
	public void addPage(IWizardPage page) {
		addPage(fileSelectionPage = new FileSelectionPage());
	}
	
	@Override
	public boolean performFinish() {
		final String fileName = fileSelectionPage.getFileName();
		if (fileName == null || fileName.length() == 0)	
			return false;
		File file = new File(fileName);
		if (!file.exists() || !file.canRead())
			return false;
		FileDocumentUtil.importFileAsync(fileName, getLib(), getRel());
		
		return true;
	}
	
	

}
