package org.simantics.document.ui.graphfile;

import java.io.File;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.Activator;
import org.simantics.editors.Editors;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.ExceptionUtils;

public class ExternalEditorAdapter extends AbstractResourceEditorAdapter implements EditorAdapter {
	
	public ExternalEditorAdapter() {
		super("External Editor",Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/page.png"));
	}

	
	@Override
	public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
		GraphFileResource gf = GraphFileResource.getInstance(g);
		DocumentResource doc = DocumentResource.getInstance(g);
		if (!g.isInstanceOf(r, doc.FileDocument))
			return false;
		String filename = g.getPossibleRelatedValue(r, gf.HasResourceName);
		return filename != null;
	}
	
	@Override
	protected void openEditor(final Resource input) throws Exception {
		SimanticsUI.getSession().asyncRequest(new ReadRequest() {
			
			@Override
			public void run(ReadGraph graph) throws DatabaseException {
				final File file = GraphFileUtil.toTempFile(graph, input);
				file.deleteOnExit();
				Display.getDefault().asyncExec(new Runnable() {
					
					@Override
					public void run() {
						
						if (file.exists() && file.canRead()) {
							try {
								Editors.openExternalEditor(file);
							} catch (PartInitException e) {
								ExceptionUtils.logAndShowError(e);
							}
						}
					}
				});
			}
		});
		

	}

}
