package org.simantics.document.ui.contribution;

import java.util.Collection;

import org.eclipse.jface.dialogs.IInputValidator;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.AdaptionUtils;

public class NameInputValidator implements IInputValidator, Widget {
	
	private Resource selection;
	
	@Override
	public String isValid(final String newText) {
		if (newText == null || newText.length() == 0)
			return "Empty name is not allowed";
		if (selection != null) {
			try {
				return Simantics.getSession().syncRequest(new Read<String>() {
					@Override
					public String perform(ReadGraph graph) throws DatabaseException {
						Layer0 l0 = Layer0.getInstance(graph);
						Resource lib = graph.getPossibleObject(selection, l0.PartOf);
						if (lib == null)
							return null;
						Collection<Resource> resources = graph.getObjects(lib, l0.ConsistsOf);
						for (Resource resource : resources) {
							if (resource.equals(selection))
								continue;
							String n = graph.getPossibleRelatedValue(resource, l0.HasName);
							if (newText.equals(n))
								return "Cannot have duplicate name " + newText;
						}
						return null;
					}
				});
			} catch (DatabaseException e) {
				return e.getMessage();
			}
		}
		return null;
	}
	
	@Override
	public void setInput(ISessionContext context, Object input) {
		selection = AdaptionUtils.adaptToSingle(input, Resource.class);
		
	}

}
