/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.document.ui.Activator;
import org.simantics.document.ui.graphfile.FileDocumentUtil;

/**
 * Action for importing files as documents.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ImportDocumentFolder implements ActionFactory {
	Resource folderType;
	Resource relation;

	public ImportDocumentFolder(ReadGraph graph, String folderTypeUri, String relationUri) throws DatabaseException {
		folderType = graph.getResource(folderTypeUri);
		relation = graph.getResource(relationUri);
	}

	@Override
	public Runnable create(Object target) {
		if(!(target instanceof Resource))
			return null;
		final Resource resource = (Resource)target;
		return new Runnable() {
			
			@Override
			public void run() {
				DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell(),SWT.OPEN);
				final String filename = dialog.open();
				if (filename == null) {
					return;
				}

				ImportJob job = new ImportJob("Import folder", resource, filename);
				job.setUser(true);
				job.schedule();
			}
		};
	}
	
	
	private class ImportJob extends DatabaseJob {

		public ImportJob(String name, Resource resource, String filename) {
			super(name);
			this.resource = resource;
			this.filename = filename;
		}

		Resource resource;
		String filename;

		@Override
		protected IStatus run(final IProgressMonitor monitor) {
			try {
				Simantics.getSession().syncRequest(new WriteRequest() {
					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
						try {
						    graph.markUndoPoint();
							FileDocumentUtil.importFolderWithName(graph,filename,resource,folderType,relation,monitor);
						} catch (Exception e) {
							throw new DatabaseException(e);
						}
					}
				});
				return new Status(IStatus.OK, Activator.PLUGIN_ID, "Folder imported.");
			} catch (DatabaseException e) {
				return new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Cannot import document folder.", e);
			}
		}
	}
	
}
