/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.actions;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ExceptionUtils;

/**
 * Action for exporting file based documents.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ExportDocumentFile implements ActionFactory {

	
	@Override
	public Runnable create(Object target) {

		if(!(target instanceof Resource))
			return null;

		final Resource resource = (Resource)target;

		return new Runnable() {
			@Override
			public void run() {
				try {
					String name = SimanticsUI.getSession().syncRequest(new Read<String>() {
						public String perform(ReadGraph graph) throws DatabaseException {
							DocumentResource doc = DocumentResource.getInstance(graph);
							GraphFileResource gf = GraphFileResource.getInstance(graph);
							if (!graph.isInstanceOf(resource, doc.FileDocument))
								return null;
							String resourceName = graph.getPossibleRelatedValue(resource, gf.HasResourceName);
							if (resourceName != null) {
								return resourceName;
							} else {
								Layer0 L0 = Layer0.getInstance(graph);
								return graph.getPossibleRelatedValue(resource, L0.HasName);
							}
						};
					});
					
					FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(),SWT.SAVE);
					dialog.setFileName(name);
					final String filename = dialog.open();
					if (filename == null)
						return;
					exportDocument(resource, filename);
				} catch (DatabaseException e) {
					ExceptionUtils.logAndShowError("Cannot export document.", e);
				}

			}
		};
	}
	
	public static void exportDocument(Resource document, String fileName) throws DatabaseException {
	    GraphFileUtil.writeDataToFile(document, new File(fileName));
	}
}
