/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.simantics.document.server.io.FileInfo;
import org.simantics.document.server.io.IChartItem;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.server.io.IDataDefinition;
import org.simantics.document.server.io.IJSONObject;
import org.simantics.document.server.io.IListItem;
import org.simantics.document.server.io.ITableCell;

public class JSONObjectUtils {
    public static String getText(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "text", "");
    }

    public static String getLink(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "link", "");
    }

    public static String getTarget(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "target", "");
    }

    public static String getHyperLinkTarget(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "hyperlinkTarget", "");
    }

    public static String getWidth(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "width", "");
    }

    public static String getHeight(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "height", "");
    }

    public static String getParent(IJSONObject object) {
        return (String)object.getValue("parent");
    }

    public static boolean enabled(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "enabled", true);
    }

    public static boolean visible(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "visible", true);
    }

    public static boolean readOnly(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "readOnly", false);
    }

    public static boolean selected(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "selected", false);
    }

    public static boolean followEditMode(IJSONObject object) {
        return JSONObjectUtils.getValueOrDefault(object, "followEditMode", true);
    }

    public static String getType(IJSONObject object) {
        String result = (String)object.getValue("type");
        if (result == null) {
            throw new IllegalStateException("No type for object " + object);
        }
        return result;
    }

    public static String getId(IJSONObject object) {
        String result = (String)object.getValue("id");
        if (result == null) {
            throw new IllegalStateException("No type for object " + object);
        }
        return result;
    }

    public static <T> T getValueOrDefault(IJSONObject object, String key, T defaultValue) {
        try {
            Object value = object.getValue(key);
            if (value != null) {
                return value;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public static String[] getStringArrayValueOrDefault(IJSONObject object, String key, String[] defaultValue) {
        try {
            Object o = object.getValue(key);
            if (o instanceof List) {
                List s = (List)o;
                return s.toArray(new String[s.size()]);
            }
            if (o instanceof String[]) {
                return (String[])o;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public static float[] getFloatArrayValueOrDefault(IJSONObject object, String key, float[] defaultValue) {
        try {
            Object o = object.getValue(key);
            if (o instanceof List) {
                List list = (List)o;
                float[] result = new float[list.size()];
                int pos = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    float value = ((Float)iterator.next()).floatValue();
                    result[pos++] = value;
                }
                return result;
            }
            if (o instanceof float[]) {
                return (float[])o;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public static int[] getIntArrayValueOrDefault(IJSONObject object, String key, int[] defaultValue) {
        try {
            Object o = object.getValue(key);
            if (o instanceof List) {
                List list = (List)o;
                int[] result = new int[list.size()];
                int pos = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    result[pos++] = i;
                }
                return result;
            }
            if (o instanceof int[]) {
                return (int[])o;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public static double[] getDoubleArrayValueOrDefault(IJSONObject object, String key, double[] defaultValue) {
        try {
            Object o = object.getValue(key);
            if (o instanceof List) {
                List list = (List)o;
                double[] result = new double[list.size()];
                int pos = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    double value = (Double)iterator.next();
                    result[pos++] = value;
                }
                return result;
            }
            if (o instanceof double[]) {
                return (double[])o;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public static Collection<ICommand> getCommands(IJSONObject object) {
        try {
            Collection result = (Collection)object.getValue("commands");
            if (result != null) {
                return result;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public static Collection<IChartItem> getChartItems(IJSONObject object) {
        try {
            String valuess;
            Object values = object.getValue("values");
            if (values == null) {
                return Collections.emptyList();
            }
            if (values instanceof String && (valuess = (String)values).length() == 0) {
                return Collections.emptyList();
            }
            return (List)values;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static Collection<IDataDefinition> getDataDefinitions(IJSONObject object) {
        try {
            List result = (List)object.getValue("dataDefinitions");
            if (result != null) {
                return result;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public static Collection<ITableCell> getTableCell(IJSONObject object) {
        try {
            String tableCellsS;
            Object tableCells = object.getValue("tableCells");
            if (tableCells instanceof String && (tableCellsS = (String)tableCells).length() == 0) {
                return Collections.emptyList();
            }
            if (tableCells != null) {
                return (List)tableCells;
            }
            return Collections.emptyList();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static Collection<FileInfo> getFiles(IJSONObject object) {
        try {
            List fileArray = (List)object.getValue("files");
            ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
            for (IJSONObject f : fileArray) {
                String name = JSONObjectUtils.getValueOrDefault(f, "name", "");
                String content = JSONObjectUtils.getValueOrDefault(f, "content", "");
                Long resourceId = JSONObjectUtils.getValueOrDefault(f, "resourceId", 0L);
                Long creationTimeMillis = JSONObjectUtils.getValueOrDefault(f, "creationTimeMillis", 0L);
                boolean canModify = JSONObjectUtils.getValueOrDefault(f, "canModify", false);
                if (name == null || content == null) continue;
                fileList.add(new FileInfo(name, content, resourceId, creationTimeMillis, canModify));
            }
            return fileList;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static List<IListItem> getListItems(IJSONObject object) {
        Object items = object.getValue("listItems");
        if (items instanceof List) {
            return (List)items;
        }
        return Collections.emptyList();
    }
}

