/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile.view;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.SCLEditor;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.operation.Layer0X;
import org.simantics.selectionview.ConfigurationComposite;


public class SCLEditorComposite extends ConfigurationComposite {
    
	private SCLEditor editor;
	
    public void create(Composite body, IWorkbenchSite site, ISessionContext context, final WidgetSupport support) {
        
    	GridLayoutFactory.fillDefaults().spacing(0, 0).equalWidth(false).numColumns(2).applyTo(body);
    	body.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
    	
    	Button button = new Button(body, support, SWT.NONE);
    	button.setText("&Apply changes");
    	button.addSelectionListener(new SelectionListenerImpl<Resource>(context) {

    		private String content;
    		
    		@Override
    		public void beforeApply() {
    			content = editor.getContent();
    			editor.getWidget().storeSelectedRange();
    			editor.getControl().setFocus();
    			editor.getWidget().restoreSelectedRange();
    		}
    		
			@Override
			public void apply(WriteGraph graph, Resource group) throws DatabaseException {
			    Layer0X L0X = Layer0X.getInstance(graph);
				graph.claimLiteral(group, L0X.HasExpression, content);
			}
			
		});
    	
    	editor = new SCLEditor(body, support, SWT.BORDER | SWT.FLAT);
    	editor.setTextFactory(new StringPropertyFactory(Layer0X.URIs.HasExpression));
    	//editor.addModifyListener(new StringPropertyModifier(context, Layer0.URIs.HasExpression));
    	GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(editor.getControl());
        
    }
    
}
