package org.simantics.diagram.profile.view;

import java.util.Collections;
import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;

public class ResourcePairLabelRule implements LabelRule {
	
    public static final ResourcePairLabelRule INSTANCE = new ResourcePairLabelRule();
    
    public ResourcePairLabelRule() {
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(ResourcePair.class);
    }

    @Override
    public Map<String,String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        return Collections.singletonMap(ColumnKeys.SINGLE, 
                NameUtils.getSafeLabel(graph, ((ResourcePair)content).getSecond())
                );
    }
}
