/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile.view;

import java.util.Collections;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.icons.ImageDescriptorProvider;

public class ResourcePairImageRule implements ImageRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(ResourcePair.class);
    }

    @Override
    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        
        ImageDescriptorProvider provider = graph.getPossibleAdapter(((ResourcePair)content).getSecond(), ImageDescriptorProvider.class);
        return provider != null ? Collections.singletonMap(ColumnKeys.SINGLE, provider.get()) : null;
        
    }

}
