/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;

public class ProfileEntryChildren implements ChildRule {

	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType.equals(ResourcePair.class);
	}

	@Override
	public Collection<?> getChildren(ReadGraph graph, Object parent)
			throws DatabaseException {

		ResourcePair entry = (ResourcePair)parent;
    	ArrayList<ResourcePair> entries = new ArrayList<ResourcePair>();
    	DiagramResource DIA = DiagramResource.getInstance(graph);
    	Resource children = graph.getPossibleObject(entry.getSecond(), DIA.HasEntries);
    	if(children == null) return Collections.emptyList();
    	else {
    		for(Resource entry2 : ProfileUtils.getProfileChildrenFromEntries(graph, children)) entries.add(new ResourcePair(entry.getFirst(), entry2));
    		return entries;
    	}
    }

	@Override
	public Collection<?> getParents(ReadGraph graph, Object child)
			throws DatabaseException {
		return new ArrayList<Resource>();
	}

}
