/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile.view;

import java.util.Collection;

import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.model.check.CheckedStateRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.request.ProfileActiveEntryResources;
import org.simantics.scenegraph.profile.request.ProfileEntryResources;
import org.simantics.simulation.ontology.SimulationResource;

public class ProfileCheckContributor implements CheckedStateRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(ResourcePair.class);
    }

    @Override
    public CheckedState getCheckedState(ReadGraph graph, Object parent)
            throws DatabaseException {

        ResourcePair entry = (ResourcePair)parent;
        DiagramResource DIA = DiagramResource.getInstance(graph);
        SimulationResource SIMU = SimulationResource.getInstance(graph);

        if(graph.isInstanceOf(entry.getSecond(), DIA.Profile)) {

            Resource list = graph.getPossibleObject(entry.getSecond(), DIA.HasEntries);
            Collection<Resource> activeEntries = graph.syncRequest( new ProfileActiveEntryResources(entry.getFirst(), list) );
            if (activeEntries.isEmpty()) {
                return CheckedState.NOT_CHECKED;
            } else {
                Collection<Resource> entries = graph.syncRequest( new ProfileEntryResources(entry.getFirst(), list) );
                return entries.equals(activeEntries) ? CheckedState.CHECKED : CheckedState.GRAYED;
            }

        } else if(graph.isInstanceOf(entry.getSecond(), DIA.ProfileEntry)) {
            if(graph.hasStatement(entry.getFirst(), SIMU.IsActive, entry.getSecond())) return CheckedState.CHECKED;	
        }

        return CheckedState.NOT_CHECKED;

    }

}
