/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile.view;

import java.util.ArrayList;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;

public class DirectProfileEntries extends UnaryRead<ResourcePair, List<ResourcePair>> {

	public DirectProfileEntries(ResourcePair resource) {
		super(resource);
	}

	@Override
	public List<ResourcePair> perform(ReadGraph graph) throws DatabaseException {
		DiagramResource dr = DiagramResource.getInstance(graph);
		ArrayList<ResourcePair> entries = new ArrayList<ResourcePair>();
		Resource list = graph.getPossibleObject(parameter.getSecond(), dr.HasEntries);
		if(list == null) return entries;
		for(Resource entry : ProfileUtils.getProfileChildrenFromEntries(graph, list)) {
			entries.add(new ResourcePair(parameter.getFirst(), entry));
		}
		return entries;
	}

}
