/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import java.util.Map;
import java.util.TreeMap;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterI.ObjectProcedure;
import org.simantics.db.impl.ClusterI.Procedure;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableSizeListener;

public final class ValueTable extends Table<byte[]> {
    public ValueTable(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getByteFactory(), sizeListener, header, headerBase);
    }
    public ValueTable(TableSizeListener sizeListener, int[] header, int headerBase, byte[] bytes) {
        super(TableFactory.getByteFactory(), sizeListener, header, headerBase, bytes);
    }
    void getValue(int valueIndex, byte[] to, int start, int size) {
        getCopy(valueIndex, to, start, size);
    }
    void getString(int valueIndex, char[] to, int start, int size) {
        byte[] bs = (byte[])table;
        start += valueIndex+offset+1;
        for(int i=0;i<size;i++) to[i] = (char)bs[start++];
//    	
//        getCopy(valueIndex, to, start, size);
    }
    void setValue(int valueIndex, byte[] value, int length) {
        setCopy(valueIndex, length, value, 0);
    }
    int createValue(byte[] value, int voffset, int vsize) {
        int valueIndex = createNewElement(vsize);
        setCopy(valueIndex, vsize, value, voffset);
        return valueIndex;
    }
    int createValue(byte[] value) {
        int valueIndex = createNewElement(value.length);
        setCopy(valueIndex, value.length, value, 0);
        return valueIndex;
    }
    void removeValue(int valueIndex, int size) {
        deleteOldElement(valueIndex, size);
    }
    boolean isEqual(int valueIndex, byte[] value) {
        return isEqual(valueIndex, value, 0, value.length);
    }
    private TreeMap<Integer, Integer> valueMap =
        new TreeMap<Integer, Integer>();
    
    private int VALUE_SIZE = 0;
    private int VALUE_OFFSET = 0;
    public void checkValueInit()
    throws DatabaseException {
        valueMap.clear();
        final int s = getTableSize();
        final int c = getTableCapacity();
        if (s < 0 || s > c)
            throw new ValidationException("Illegal value table size=" + s + " cap=" + c);
        VALUE_SIZE = s;
        VALUE_OFFSET = getTableBase() - ValueTable.ZERO_SHIFT; 
    }
    public void checkValue(int capacity, int index)
    throws DatabaseException {
        if (0 == capacity && 0 == index)
            return;
        if (capacity < 1)
            throw new ValidationException("Illegal resource value capacity=" + capacity);
        if (index < 1)
            throw new ValidationException("Illegal resource value index=" + index);
        if (VALUE_SIZE < capacity + index + VALUE_OFFSET)
            throw new ValidationException("Illegal resource value c=" + capacity +
                    " i=" + index + " ts=" + VALUE_SIZE + " off=" + VALUE_OFFSET);
        // Duplicate index is allowed because new index is created only if new size is greater than old.
        Integer valueCap = valueMap.get(index);
        if (null == valueCap)
            valueMap.put(index, capacity);
        else if (capacity > valueCap)
            valueMap.put(index, capacity);
        else
            valueMap.put(index, valueCap);
    }
    public void checkValueFini()
    throws DatabaseException {
        int last = 0;
        for (Map.Entry<Integer, Integer> e : valueMap.entrySet()) {
            int i = e.getKey();
            int c = e.getValue();
            int cur = VALUE_OFFSET + i;
            if (last > cur)
                throw new ValidationException("Index error with resource value c=" + c +
                        " i=" + i + " ts=" + VALUE_SIZE + " off=" + VALUE_OFFSET);
            last = cur + c;
        }
    }

    @Override
    public <Context> boolean foreach(int setIndex, Procedure procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

}
