/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI.Procedure;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableSizeListener;

public class OperationTable extends Table<int[]> {

	    OperationTable(TableSizeListener sizeListener, int[] header, int headerBase, int[] ints) {
	        super(TableFactory.getIntFactory(), sizeListener, header, headerBase, ints);
	    }
		int getOperationCount() {
			return getTableCount();
		}
		int createOperation(int type, int argIndex, int valIndex, int valSize) {
			int tableIndex = createNewElement(4);
		    int realIndex = checkIndexAndGetRealIndex(tableIndex, 4);
			int[] table = getTable();
			table[realIndex] = type;
			table[++realIndex] = argIndex;
			table[++realIndex] = valIndex;
			table[++realIndex] = valSize;
		    return tableIndex - ZERO_SHIFT; // operation index is zero based
		}
		int getOperationType(int opIndex) {
			int tableIndex = ZERO_SHIFT + opIndex*4;
		    int realIndex = checkIndexAndGetRealIndex(tableIndex, 4);
			int[] table = getTable();
			return table[realIndex];
		}
		int getOperationArgumentIndex(int opIndex) {
			int tableIndex = ZERO_SHIFT + opIndex*4;
		    int realIndex = checkIndexAndGetRealIndex(tableIndex, 4);
			int[] table = getTable();
			return table[++realIndex];
		}
		int getValueIndex(int opIndex) {
			int tableIndex = ZERO_SHIFT + opIndex*4;
		    int realIndex = checkIndexAndGetRealIndex(tableIndex, 4);
			int[] table = getTable();
			return table[realIndex+2];
		}
		int getValueSize(int opIndex) {
			int tableIndex = ZERO_SHIFT + opIndex*4;
		    int realIndex = checkIndexAndGetRealIndex(tableIndex, 4);
			int[] table = getTable();
			return table[realIndex+3];
		}
        @Override
        public <Context> boolean foreach(int setIndex, Procedure procedure, Context context,
                ClusterSupport support, Modifier modifier) throws DatabaseException {
            throw new UnsupportedOperationException();
        }
}
