/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterI.Procedure;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ResourceUID;

import gnu.trove.map.hash.TIntShortHashMap;

final public class ForeignTableSmall extends Table<long[]>
{
    private IClusterTable clusterTable;
    public ForeignTableSmall(ClusterBase sizeListener, int[] header, int headerBase) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase);
        this.clusterTable = sizeListener.getClusterTable();
    }
    public ForeignTableSmall(ClusterBase sizeListener, int[] header, int headerBase, long[] longs) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase, longs);
        this.clusterTable = sizeListener.getClusterTable();
    }
    public int getUsedSize() {
        return getTableCount();
    }
    static long rmTime = 0;
    public TIntShortHashMap getResourceHashMap()
    throws DatabaseException {
//        long start = System.nanoTime();
        int ELEMENT_SIZE = ForeignElement.getSizeOf();
        assert(ELEMENT_SIZE == 3);
        final int TABLE_SIZE = getTableCount();
        final int FOREIGN_COUNT = getForeignCount();
        final int BASE = this.getTableBase();
        final int TOP = BASE + TABLE_SIZE * ELEMENT_SIZE;
        long[] table = this.getTable();
        int count = 0;
        int index = ZERO_SHIFT;
        
        long firstCache = 0;
        long secondCache = 0;
        int clusterKeyCache = 0;
        
        TIntShortHashMap hm = new TIntShortHashMap(FOREIGN_COUNT);
        for (int i=BASE; i<TOP && count<FOREIGN_COUNT;
        i+=ELEMENT_SIZE, ++index) {
            
            if (0 == table[i] && 0 == table[i+1] && 0 == table[i+2])
                continue; // element has been deleted
            
            long first = table[i];
            long second = table[i+1];
            long third = table[i+2];
            
            int clusterKey = 0;
            if(firstCache == first && secondCache == second) {
                clusterKey = clusterKeyCache;
            }
            if(clusterKey == 0) {
                clusterKey = clusterTable.getClusterKeyByUID(first, second);
//                cluster = clusterTable.getClusterByClusterUIDOrMakeProxy(ClusterUID.make(first, second));
                clusterKeyCache = clusterKey;
                firstCache = first;
                secondCache =second;
            }
            
            int resourceKey = ClusterTraits.createResourceKey(clusterKey, (int)third);
            hm.put(resourceKey, ClusterTraitsSmall.makeForeignRef((short)index));
            ++count;
            
        }
        if (FOREIGN_COUNT != hm.size())
            throw new DatabaseException("Foreign table has been corrupted. count=" + FOREIGN_COUNT + "size=" + hm.size());
//        rmTime += System.nanoTime()-start;
//        System.err.println("rmTime: " + 1e-9*rmTime+"s.");
        return hm;
    }
    short createForeign(int resourceKey, ClusterUID cuid) {
        int index = getTableCount();
        int size = ForeignElement.getSizeOf();
        int foreignIndex = createNewElement(size);
        int realIndex = checkIndexAndGetRealIndex(foreignIndex, size);
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(resourceKey);
        //ClusterUID cuid = clusterTable.getClusterUIDByResourceKey(resourceKey);
        ResourceUID uid = cuid.toRID(resourceIndex);
        ForeignElement.constructForeign(getTable(), realIndex, uid);
        incForeignCount();
        return ClusterTraitsSmall.makeForeignRef((short)(index + ZERO_SHIFT));
    }
    short createForeign(int resourceKey) {
        int index = getTableCount();
        int size = ForeignElement.getSizeOf();
        int foreignIndex = createNewElement(size);
        int realIndex = checkIndexAndGetRealIndex(foreignIndex, size);
        short resourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(resourceKey);
        ClusterI cluster = clusterTable.getClusterProxyByResourceKey(resourceKey);
        //ClusterI cluster = clusterTable.getClusterByResourceKey(resourceKey);
        ClusterUID cuid = cluster.getClusterUID();
        ResourceUID uid = cuid.toRID(resourceIndex);
        ForeignElement.constructForeign(getTable(), realIndex, uid);
        incForeignCount();
        return ClusterTraitsSmall.makeForeignRef((short)(index + ZERO_SHIFT));
    }
    void deleteForeign(int foreignIndex) {
        int realIndex = checkIndexAndGetRealIndex(foreignIndex);
        ForeignElement.destructForeign(getTable(), realIndex);
        decForeignCount();
    }
    public final ResourceUID getResourceUID(int foreignIndex) {
        return ForeignElement.getResourceUID(table, checkIndexAndGetRealIndex(foreignIndex)); 
    }
    final void fillResourceUID(int foreignIndex, ClusterSmall cluster) {
        ForeignElement.fillResourceUID(table, checkIndexAndGetRealIndex(foreignIndex), cluster); 
    }
    int getForeignCount() {
        return getExtra(FOREIGN_COUNT_INDEX);
    }
    private static final int FOREIGN_COUNT_INDEX = 0;
    private int incForeignCount() {
        int count = getExtra(FOREIGN_COUNT_INDEX) + 1;
        setExtra(FOREIGN_COUNT_INDEX, count);
        return count;
    }
    private int decForeignCount() {
        int count = getExtra(FOREIGN_COUNT_INDEX) - 1;
        setExtra(FOREIGN_COUNT_INDEX, count);
        return count;
    }
    private int checkIndexAndGetRealIndex(int foreignIndex) {
        int index = (foreignIndex - ZERO_SHIFT) * ForeignElement.getSizeOf() + ZERO_SHIFT;
        int realIndex = checkIndexAndGetRealIndex(index, ForeignElement.getSizeOf());
        return realIndex;
    }
    @Override
    public <Context> boolean foreach(int setIndex, Procedure procedure, Context context,
            ClusterSupport support, Modifier modifier) throws DatabaseException {
        throw new UnsupportedOperationException();
    }
}
