/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import java.io.IOException;

import org.simantics.db.SessionManager;

public class SessionManagerFactoryImpl implements SessionManagerFactory {
	static SessionManagerFactoryImpl sessionManagerFactoryImpl = new SessionManagerFactoryImpl();
    static SessionManagerImpl        sessionManagerImpl        = null;

	public static SessionManagerFactoryImpl getInstance() {
		return sessionManagerFactoryImpl;
	}
	public static void finish() {
	    if(sessionManagerImpl != null)
	        sessionManagerImpl.finish();
		sessionManagerImpl = null;
	}
	@Override
	public SessionManager createSessionManager() throws IOException {
		if (null == sessionManagerImpl)
			sessionManagerImpl = new SessionManagerImpl();
		return sessionManagerImpl;
	}
}
