package fi.vtt.simantics.procore.internal;

import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterCollectorPolicy.CollectorCluster;

class ClusterCollectorSupportImpl implements ClusterCollectorSupport {

	private final ClusterTable clusterTable;

	ClusterCollectorSupportImpl(ClusterTable clusterTable) {
		this.clusterTable = clusterTable;
	}

	@Override
	public void setPolicy(ClusterCollectorPolicy policy) {
		clusterTable.setCollectorPolicy(policy);
	}
	
	@Override
	public int getCurrentSize() {
		return (int)this.clusterTable.getSizeInBytes();
	}
	
	@Override
	public long getClusterSize(CollectorCluster id) {
	    return clusterTable.getClusterByClusterId(id.getClusterId()).getCachedSize();
	}
	
	@Override
	public Iterable<CollectorCluster> getResidentClusters() {
		return clusterTable.importanceMap.values();
	}

	@Override
	public void release(CollectorCluster id) {
		clusterTable.release(id);
	}
	
}