/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.gfx;

import org.eclipse.swt.graphics.Color;

/**
 * Utilities for dealing with SWT Color.
 * 
 * @author Tuukka Lehtonen
 */
public class ColorUtils {

	/*
     * Blend two colors (SWT) by linearly interpolating between the specified ratio
     * (0-1). 0 means <code>src</code> color only and 1 means <code>dst</code>
     * color only.
     * 
     * @param src
     * @param dst
     * @param ratio a value between [0,1]
     * @return a new instance of Color, containing the interpolated result.
     *         Remember to dispose of this color when its no longer needed!
     */
    public static Color blend(Color src, Color dst, double ratio) {
        if (ratio < 0 || ratio > 1)
            throw new IllegalArgumentException("expected t in [0,1], got t " + ratio);
        
        double r1 = src.getRed();
        double g1 = src.getGreen();
        double b1 = src.getBlue();
        double r2 = dst.getRed();
        double g2 = dst.getGreen();
        double b2 = dst.getBlue();
        
        double r = r1 + (r2 - r1) * ratio;
        double g = g1 + (g2 - g1) * ratio;
        double b = b1 + (b2 - b1) * ratio;
        
        return new Color(src.getDevice(), (int) r, (int) g, (int) b);
    }

    /**
     * Blend two colors (AWT) by linearly interpolating between the specified ratio
     * (0-1). 0 means <code>src</code> color only and 1 means <code>dst</code>
     * color only.
     * 
     * @param src
     * @param dst
     * @param ratio a value between [0,1]
     * @return a new instance of Color, containing the interpolated result.
     *         Remember to dispose of this color when its no longer needed!
     */
    public static java.awt.Color blend(java.awt.Color src, java.awt.Color dst, double ratio) {
        if (ratio < 0 || ratio > 1)
            throw new IllegalArgumentException("expected t in [0,1], got t " + ratio);

        double r1 = src.getRed();
        double g1 = src.getGreen();
        double b1 = src.getBlue();
        double a1 = src.getAlpha();
        double r2 = dst.getRed();
        double g2 = dst.getGreen();
        double b2 = dst.getBlue();
        double a2 = dst.getAlpha();

        double r = r1 + (r2 - r1) * ratio;
        double g = g1 + (g2 - g1) * ratio;
        double b = b1 + (b2 - b1) * ratio;
        double a = a1 + (a2 - a1) * ratio;

        return new java.awt.Color((int) r, (int) g, (int) b, (int) a);
    }

}
