/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.team.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.common.utils.Logger;
import org.simantics.team.ui.Command;

public class UndoToSelectedRevisionHandler extends AbstractHandler {
    public UndoToSelectedRevisionHandler() {
    }
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection(event);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            try {
                Object o = ss.getFirstElement();
                if (null != o && o instanceof Command)
                    ((Command)o).undoToSelectedRevision();
          } catch (Exception e) {
              Logger.defaultLogError(e);
          }
        }
        return null;
    }
}
