/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.project;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.layer0.Layer0;
import org.simantics.project.IProject;
import org.simantics.simulation.Activator;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.model.IModel;
import org.simantics.simulation.project.ExperimentManagerKeys;
import org.simantics.simulation.project.ExperimentManagerMode;
import org.simantics.simulation.project.IExperimentActivationListener;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.project.IExperimentManagerListener;
import org.simantics.simulation.project.ProxyExperimentActivationListener;
import org.simantics.ui.workbench.WorkbenchShutdownService;
import org.simantics.utils.datastructures.ListenerList;

public class ExperimentManager
implements IExperimentManager {
    CopyOnWriteArrayList<IExperimentManagerListener> listeners = new CopyOnWriteArrayList();
    ListenerList<IExperiment> experiments = new ListenerList(IExperiment.class);
    IExperiment activeExperiment;
    AtomicBoolean isDisposed = new AtomicBoolean(false);

    public ExperimentManager() {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(WorkbenchShutdownService.class.getName());
        if (ref != null) {
            WorkbenchShutdownService shutdown = (WorkbenchShutdownService)context.getService(ref);
            shutdown.registerShutdownHook(new Runnable(){

                @Override
                public void run() {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                ExperimentManager.this.dispose(monitor);
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    try {
                        if (PlatformUI.isWorkbenchRunning()) {
                            IProgressService progress = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
                            progress.run(true, false, runnable);
                        } else {
                            runnable.run(null);
                        }
                    }
                    catch (InvocationTargetException e) {
                        Activator.logError("Experiment manager shutdown failed, see exception for details.", e.getCause());
                    }
                    catch (InterruptedException e) {
                        Activator.logError("Experiment manager shutdown was interrupted, see exception for details.", e);
                    }
                }
            });
            context.ungetService(ref);
        }
    }

    protected void manageExperiment(IExperiment experiment, boolean setActive) {
        this.experiments.add((Object)experiment);
        experiment.addListener(new ManagingExperimentListener(experiment, setActive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startExperiment(final Resource experimentResource, final IExperimentActivationListener listener, final boolean setActive) {
        ExperimentManager experimentManager = this;
        synchronized (experimentManager) {
            ExperimentManagerMode mode = this.getMode();
            if (mode == ExperimentManagerMode.SINGLE_EXPERIMENT && this.activeExperiment != null && setActive) {
                this.activeExperiment.shutdown(null);
            }
        }
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                LifecycleSupport ls = (LifecycleSupport)g.getService(LifecycleSupport.class);
                if (ls.isClosing() || ls.isClosed()) {
                    return;
                }
                Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                IModel model = (IModel)g.adaptUnique(g.getSingleObject(experimentResource, L0.PartOf), IModel.class);
                ProxyExperimentActivationListener proxy = new ProxyExperimentActivationListener(listener){

                    @Override
                    public void onExperimentActivated(IExperiment experiment) {
                        if (experiment != null) {
                            ExperimentManager.this.manageExperiment(experiment, setActive);
                        }
                        super.onExperimentActivated(experiment);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        super.onFailure(e);
                    }
                };
                model.loadExperiment(g, experimentResource, proxy);
            }
        }, (Procedure)new ProcedureAdapter<Object>(){

            public void exception(Throwable t) {
                listener.onFailure(t);
            }
        });
    }

    synchronized void setActiveExperiment(IExperiment experiment) {
        if (this.getMode() == ExperimentManagerMode.SINGLE_EXPERIMENT && this.activeExperiment != null) {
            this.activeExperiment.shutdown(null);
            for (IExperimentManagerListener listener : this.listeners) {
                listener.activeExperimentUnloaded();
            }
        }
        this.activeExperiment = experiment;
        for (IExperimentManagerListener listener : this.listeners) {
            listener.activeExperimentLoaded(experiment);
        }
    }

    private synchronized void removeActiveExperiment(IExperiment experiment) {
        if (this.activeExperiment == experiment) {
            this.activeExperiment = null;
            for (IExperimentManagerListener listener : this.listeners) {
                listener.activeExperimentUnloaded();
            }
        }
    }

    @Override
    public synchronized void addListener(IExperimentManagerListener listener) {
        this.listeners.add(listener);
        if (this.activeExperiment != null) {
            listener.activeExperimentLoaded(this.activeExperiment);
        }
    }

    @Override
    public synchronized void removeListener(IExperimentManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose(IProgressMonitor monitor) {
        if (this.isDisposed.compareAndSet(false, true)) {
            if (this.activeExperiment != null) {
                this.activeExperiment.shutdown(monitor);
            }
            this.activeExperiment = null;
            for (IExperimentManagerListener listener : this.listeners) {
                listener.managerDisposed();
            }
            if (!this.listeners.isEmpty()) {
                System.err.println("ExperimentManager still contains the following listeners after disposal:");
                for (IExperimentManagerListener listener : this.listeners) {
                    System.err.println("\t" + listener);
                }
            }
        }
    }

    @Override
    public IExperiment getActiveExperiment() {
        return this.activeExperiment;
    }

    @Override
    public IExperiment getExperiment(String identifier) {
        if (identifier == null) {
            return null;
        }
        IExperiment[] iExperimentArray = (IExperiment[])this.experiments.getListeners();
        int n = iExperimentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExperiment experiment = iExperimentArray[n2];
            if (experiment != null && identifier.equals(experiment.getIdentifier())) {
                return experiment;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IExperiment[] getExperiments() {
        return (IExperiment[])this.experiments.getListeners();
    }

    private ExperimentManagerMode getMode() {
        ExperimentManagerMode mode = ExperimentManagerMode.MULTI_EXPERIMENT;
        IProject project = Simantics.peekProject();
        if (project == null) {
            return mode;
        }
        mode = (ExperimentManagerMode)((Object)project.getHint(ExperimentManagerKeys.EXPERIMENT_MANAGER_MODE));
        return mode != null ? mode : ExperimentManagerMode.MULTI_EXPERIMENT;
    }

    class ManagingExperimentListener
    implements IExperimentListener {
        IExperiment experiment;
        boolean setActive;

        public ManagingExperimentListener(IExperiment experiment, boolean setActive) {
            this.experiment = experiment;
            this.setActive = setActive;
        }

        @Override
        public void stateChanged(ExperimentState state) {
            if (state == ExperimentState.RUNNING || state == ExperimentState.STOPPED) {
                if (this.setActive && ExperimentManager.this.activeExperiment != this.experiment) {
                    ExperimentManager.this.setActiveExperiment(this.experiment);
                }
            } else if (state == ExperimentState.DISPOSED) {
                ExperimentManager.this.removeActiveExperiment(this.experiment);
                ExperimentManager.this.experiments.remove((Object)this.experiment);
                this.experiment.removeListener(this);
                this.experiment = null;
            }
        }
    }
}

