/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.AbstractSorter;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.browsing.ui.model.sorters.SorterRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.ComparablePair;

public class StandardPropertySorterRule implements SorterRule {    
    
	final private Sorter sorter;
	
	public StandardPropertySorterRule(Resource rule) {
		this.sorter = new StandardSorter(rule);
	}
	
	static class StandardSorter extends AbstractSorter<ComparablePair<String, String>> {
		
		final private Resource rule;
		
		public StandardSorter(Resource rule) {
			this.rule = rule;
		}

		@Override
		public ComparablePair<String, String> getSortingCriterion(ReadGraph graph, BrowseContext context, NodeContext node) throws DatabaseException {

			Object content = node.getConstant(BuiltinKeys.INPUT);
			if(content instanceof Variable) {
				Variable var = (Variable)content;
	    		Variable info = var.getPossibleProperty(graph, SelectionVariables.PROPERTY_INFO);
	    		// FIXME: what is this block ??
	    		if(info == null) { 
//	    			System.err.println("null info for " + ((Variable)content).getURI(graph));
//	    			info = ((Variable)content).getPossiblePropertyValue(graph, SelectionVariables.PROPERTY_INFO);
		    		return ComparablePair.make("", ((Variable)content).getName(graph));
	    		}
	    		
	    		Variable special = SelectionViewUtils.getSpecialCategory(graph, rule, info);
	    		if(special != null) info = special;
	    		
	    		String cat = info.getPossiblePropertyValue(graph, SelectionVariables.CATEGORY_SORTING_NAME, Bindings.STRING);
	    		if(cat == null) {
	    			cat = info.getPossiblePropertyValue(graph, SelectionVariables.CATEGORY_NAME, Bindings.STRING);
	    			if(cat == null) cat = "";
	    		}
	    		String label = ((Variable)content).getPossiblePropertyValue(graph, SelectionVariables.PROPERTY_SORTING_NAME, Bindings.STRING);
	    		if(label == null) label = ((Variable)content).getPossiblePropertyValue(graph, ColumnKeys.DISPLAY_PROPERTY, Bindings.STRING);
	    		if(label == null) label = "Invalid label for " + ((Variable)content).getURI(graph); 
	    		return ComparablePair.make(cat,label);
				
			} else if (content instanceof CategoryNode) {
				return ComparablePair.make(((CategoryNode)content).getSortingName(), "");
			}
			
			throw new IllegalArgumentException("Content type should be Variable or CategoryNode");
			
		}

		@Override
		public int compare(ComparablePair<String, String> a, ComparablePair<String, String> b) {
			return a.compareTo(b);
		}
		
	};
	
	
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    @Override
    public Sorter getSorter(ReadGraph graph, Object content)
            throws DatabaseException {
        return sorter;
    }

}
