/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime;

import gnu.trove.map.hash.THashMap;

public class SCLContext
extends THashMap<String, Object> {
    private static ThreadLocal<SCLContext> CONTEXT = new ThreadLocal();
    private static ThreadLocal<OldContextNode> OLD_CONTEXT = new ThreadLocal();

    public static SCLContext getCurrent() {
        SCLContext context = CONTEXT.get();
        if (context == null) {
            context = new SCLContext();
            CONTEXT.set(context);
        }
        return context;
    }

    public static void push(SCLContext newContext) {
        SCLContext oldContext = CONTEXT.get();
        if (oldContext != null) {
            OLD_CONTEXT.set(new OldContextNode(oldContext, OLD_CONTEXT.get()));
        }
        CONTEXT.set(newContext);
    }

    public static void pop() {
        OldContextNode node = OLD_CONTEXT.get();
        if (node == null) {
            CONTEXT.set(null);
        } else {
            CONTEXT.set(node.context);
            OLD_CONTEXT.set(node.next);
        }
    }

    private static class OldContextNode {
        final SCLContext context;
        final OldContextNode next;

        public OldContextNode(SCLContext context, OldContextNode next) {
            this.context = context;
            this.next = next;
        }
    }
}

