/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.query;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.graph.query.CompositeGraph;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.graph.representation.old.OldTransferableGraph1;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IdentityStore;
import org.simantics.graph.store.StatementStore;
import org.simantics.graph.store.ValueStore;

public class TransferableGraphConversion {
    private static StatementStore extractStatements(TransferableGraph1 tg) {
        StatementStore statements = new StatementStore();
        int[] array = tg.statements;
        int i = 0;
        while (i < array.length) {
            int subject = array[i++];
            int predicate = array[i++];
            int inverse = array[i++];
            int object = array[i++];
            statements.add(subject, predicate, object);
            if (inverse < 0) continue;
            statements.add(object, inverse, subject);
        }
        return statements;
    }

    public static IdentityStore extractIdentities(TransferableGraph1 tg) {
        return TransferableGraphConversion.extractIdentities(tg.resourceCount, tg.identities);
    }

    public static IdentityStore extractIdentities(OldTransferableGraph1 tg) {
        return TransferableGraphConversion.extractIdentities(tg.resourceCount, tg.identities);
    }

    private static IdentityStore extractIdentities(int resourceCount, Identity[] ids) {
        IdentityStore identities = new IdentityStore();
        identities.setResourceCount(resourceCount);
        Identity[] identityArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            IdentityDefinition def;
            Identity identity = identityArray[n2];
            if (identity.definition instanceof Root) {
                def = (Root)identity.definition;
                identities.defineRoot(def.name, identity.resource);
            } else if (identity.definition instanceof External) {
                def = (External)identity.definition;
                identities.defineChild(((External)def).parent, ((External)def).name, identity.resource);
            } else if (identity.definition instanceof Optional) {
                def = (Optional)identity.definition;
                identities.defineChild(((Optional)def).parent, ((Optional)def).name, identity.resource);
            } else if (identity.definition instanceof Internal) {
                def = (Internal)identity.definition;
                identities.defineChild(((Internal)def).parent, ((Internal)def).name, identity.resource);
            }
            ++n2;
        }
        return identities;
    }

    private static ValueStore extractValues(TransferableGraph1 tg) {
        ValueStore values = new ValueStore();
        Value[] valueArray = tg.values;
        int n = tg.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            values.setValue(value.resource, value.value);
            ++n2;
        }
        return values;
    }

    public static GraphStore convert(TransferableGraph1 tg) {
        return new GraphStore(TransferableGraphConversion.extractStatements(tg), TransferableGraphConversion.extractIdentities(tg), TransferableGraphConversion.extractValues(tg), new THashMap());
    }

    public static TransferableGraph1 convert(final IGraph cg, final GraphStore store) {
        final TIntIntHashMap inverseMap = new TIntIntHashMap();
        final TIntHashSet withoutInverse = new TIntHashSet();
        final Paths paths = cg.getPaths();
        store.statements.getPredicates().forEach(new TIntProcedure(){

            public boolean execute(int id) {
                Iterator<Res> iterator = cg.rawGetObjects(store.idToRes(id), paths.InverseOf).iterator();
                if (iterator.hasNext()) {
                    Res inverse = iterator.next();
                    int inv = store.createResToId(inverse);
                    inverseMap.put(id, inv);
                    inverseMap.put(inv, id);
                    return true;
                }
                withoutInverse.add(id);
                return true;
            }
        });
        if (!withoutInverse.isEmpty()) {
            IdentityStore identities = store.identities;
            StatementStore statements = store.statements;
            int inverseOfId = identities.pathToId(paths.InverseOf);
            if (inverseOfId >= 0) {
                int id = 0;
                while (id < store.identities.getResourceCount()) {
                    TIntArrayList invs = statements.getObjects(id, inverseOfId);
                    if (!invs.isEmpty()) {
                        int inv = invs.getQuick(0);
                        inverseMap.put(id, inv);
                        inverseMap.put(inv, id);
                    }
                    ++id;
                }
            }
        }
        TransferableGraph1 tg = new TransferableGraph1(store.identities.getResourceCount(), store.identities.toArray(), store.statements.toArray(inverseMap), store.values.toArray());
        return tg;
    }

    public static TransferableGraph1 convert(GraphStore store) {
        TransferableGraph1 tg = new TransferableGraph1(store.identities.getResourceCount(), store.identities.toArray(), store.statements.toArray(), store.values.toArray());
        return tg;
    }

    public static CompositeGraph convert(Paths paths, Collection<TransferableGraph1> tgs) {
        CompositeGraph graph = new CompositeGraph(paths);
        for (TransferableGraph1 tg : tgs) {
            graph.addFragment(TransferableGraphConversion.convert(tg));
        }
        return graph;
    }
}

